/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.content.SharedPreferences;
import android.os.Message;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.model.persistence.BeaconScan;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScannerListener;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class BeaconActionHistoryPublisher
implements ScannerListener,
RunLoop.MessageHandlerCallback {
    public static final String SUPRESSION_TIME_STORE_SHARED_PREFS_TAG = "com.sensorberg.sdk.SupressionTimeStore";
    private static final int MSG_PUBLISH_HISTORY = 1;
    private static final int MSG_DELETE_ALL_DATA = 6;
    private static final int MSG_SAVE_SUPPRESSION_STORE = 7;
    private Clock clock;
    private final RunLoop runloop;
    private final Transport transport;
    private ResolverListener resolverListener = ResolverListener.NONE;
    private final SharedPreferences sharedPreferences;
    private final Gson gson;
    private List<BeaconScan> beaconScans = Collections.synchronizedList(new LinkedList());
    private List<BeaconAction> beaconActions = Collections.synchronizedList(new LinkedList());
    private HashMap<String, Long> suppressionTimeStore = new HashMap();

    public BeaconActionHistoryPublisher(Transport transport, Clock clock, HandlerManager handlerManager, SharedPreferences sharedPrefs, Gson gson) {
        this.transport = transport;
        this.clock = clock;
        this.runloop = handlerManager.getBeaconPublisherRunLoop(this);
        this.sharedPreferences = sharedPrefs;
        this.gson = gson;
        this.loadAllData();
    }

    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        this.beaconScans.add(BeaconScan.from(scanEvent));
    }

    @Override
    public void handleMessage(Message queueEvent) {
        switch (queueEvent.what) {
            case 1: {
                this.publishHistorySynchronously();
                break;
            }
            case 6: {
                this.deleteAllData();
                break;
            }
            case 7: {
                this.saveSuppressionTimeStore();
            }
        }
    }

    private void publishHistorySynchronously() {
        final LinkedList<BeaconScan> notSentScans = new LinkedList<BeaconScan>(this.beaconScans);
        final LinkedList<BeaconAction> notSentActions = new LinkedList<BeaconAction>(this.beaconActions);
        if (notSentScans.isEmpty() && notSentActions.isEmpty()) {
            Logger.log.logBeaconHistoryPublisherState("nothing to report");
            return;
        }
        Logger.log.logBeaconHistoryPublisherState("reporting " + notSentScans.size() + " scans and " + notSentActions.size() + " actions");
        this.transport.publishHistory(notSentScans, notSentActions, new TransportHistoryCallback(){

            @Override
            public void onSuccess(List<BeaconScan> scanObjectList, List<BeaconAction> actionList) {
                BeaconActionHistoryPublisher.this.beaconActions.removeAll(notSentActions);
                BeaconActionHistoryPublisher.this.beaconScans.removeAll(notSentScans);
                Logger.log.logBeaconHistoryPublisherState("published " + notSentActions.size() + " campaignStats and " + notSentScans.size() + " beaconStats successfully.");
                BeaconActionHistoryPublisher.this.saveAllData();
            }

            @Override
            public void onFailure(Exception throwable) {
                Logger.log.logError("not able to publish history", throwable);
            }

            @Override
            public void onInstantActions(List<BeaconEvent> instantActions) {
                BeaconActionHistoryPublisher.this.resolverListener.onResolutionsFinished(instantActions);
            }
        });
    }

    public void publishHistory() {
        this.runloop.add(this.runloop.obtainMessage(1));
    }

    public void onActionPresented(BeaconEvent beaconEvent) {
        this.beaconActions.add(BeaconAction.from(beaconEvent));
    }

    public void deleteAllObjects() {
        this.runloop.sendMessage(6);
    }

    public boolean actionShouldBeSuppressed(long lastAllowedPresentationTime, UUID actionUUID) {
        boolean value;
        boolean bl = value = this.suppressionTimeStore.get(actionUUID.toString()) >= lastAllowedPresentationTime;
        if (!value) {
            this.suppressionTimeStore.put(actionUUID.toString(), this.clock.now());
            this.runloop.add(this.runloop.obtainMessage(7));
        }
        return value;
    }

    public boolean actionWasShownBefore(UUID actionUUID) {
        boolean value = this.suppressionTimeStore.containsKey(actionUUID.toString());
        if (!value) {
            this.suppressionTimeStore.put(actionUUID.toString(), this.clock.now());
            this.runloop.add(this.runloop.obtainMessage(7));
        }
        return value;
    }

    private void loadAllData() {
        String scanJson;
        String actionJson = this.sharedPreferences.getString("com.sensorberg.sdk.InternalBeaconActions", "");
        if (!actionJson.isEmpty()) {
            Type listType = new TypeToken<List<BeaconAction>>(){}.getType();
            this.beaconActions = Collections.synchronizedList((List)this.gson.fromJson(actionJson, listType));
        }
        if (!(scanJson = this.sharedPreferences.getString("com.sensorberg.sdk.BeaconScan", "")).isEmpty()) {
            Type listType = new TypeToken<List<BeaconScan>>(){}.getType();
            this.beaconScans = Collections.synchronizedList((List)this.gson.fromJson(scanJson, listType));
        }
        Logger.log.logBeaconHistoryPublisherState("loaded " + this.beaconActions.size() + " campaignStats and " + this.beaconScans.size() + " beaconStats from shared preferences");
        String supressionTimeStoreString = this.sharedPreferences.getString(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG, "");
        if (!supressionTimeStoreString.isEmpty()) {
            Type hashMapType = new TypeToken<HashMap<String, Long>>(){}.getType();
            this.suppressionTimeStore = (HashMap)this.gson.fromJson(supressionTimeStoreString, hashMapType);
        }
    }

    public void saveAllData() {
        String actionsJson = this.gson.toJson(this.beaconActions);
        String scansJson = this.gson.toJson(this.beaconScans);
        String supressionTimeStoreJson = this.gson.toJson(this.suppressionTimeStore);
        if (Logger.isVerboseLoggingEnabled()) {
            try {
                Logger.log.logBeaconHistoryPublisherState("size of the stats campaignStats:" + actionsJson.getBytes("UTF-8").length + " beaconStats:" + scansJson.getBytes("UTF-8").length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString("com.sensorberg.sdk.InternalBeaconActions", actionsJson).putString("com.sensorberg.sdk.BeaconScan", scansJson).putString(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG, supressionTimeStoreJson).apply();
        Logger.log.logBeaconHistoryPublisherState("saved " + this.beaconActions.size() + " campaignStats and " + this.beaconScans.size() + " beaconStats and " + this.suppressionTimeStore.size() + " supression related items to shared preferences");
    }

    public void saveSuppressionTimeStore() {
        String supressionTimeStoreJson = this.gson.toJson(this.suppressionTimeStore);
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG, supressionTimeStoreJson).apply();
    }

    private void deleteSavedBeaconScansFromSharedPreferences() {
        if (this.sharedPreferences.contains("com.sensorberg.sdk.InternalBeaconActions")) {
            this.sharedPreferences.edit().remove("com.sensorberg.sdk.BeaconScan").apply();
        }
    }

    private void deleteSavedBeaconActionsFromSharedPreferences() {
        if (this.sharedPreferences.contains("com.sensorberg.sdk.InternalBeaconActions")) {
            this.sharedPreferences.edit().remove("com.sensorberg.sdk.BeaconScan").apply();
        }
    }

    private void deleteSuppressionTimeStore() {
        if (this.sharedPreferences.contains(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG)) {
            this.sharedPreferences.edit().remove(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG).apply();
        }
    }

    public void deleteAllData() {
        Logger.log.logBeaconHistoryPublisherState("will purge the saved data of " + this.beaconActions.size() + " campaignStats and " + this.beaconScans.size() + " beaconStats");
        this.beaconActions = Collections.synchronizedList(new LinkedList());
        this.beaconScans = Collections.synchronizedList(new LinkedList());
        this.suppressionTimeStore = new HashMap();
        this.deleteSuppressionTimeStore();
        this.deleteSavedBeaconScansFromSharedPreferences();
        this.deleteSavedBeaconActionsFromSharedPreferences();
    }

    public void setResolverListener(ResolverListener resolverListener) {
        this.resolverListener = resolverListener;
    }
}

