/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.utils.ListUtils;

public class InternalBeaconAction {
    public static final String SHARED_PREFS_TAG = "com.sensorberg.sdk.InternalBeaconActions";
    public static final ListUtils.Mapper<InternalBeaconAction, BeaconAction> TO_BEACON_ACTION = new ListUtils.Mapper<InternalBeaconAction, BeaconAction>(){

        @Override
        public BeaconAction map(InternalBeaconAction internalBeaconAction) {
            return internalBeaconAction.getBeaconAction();
        }
    };
    @Expose
    private BeaconAction beaconAction;
    @Expose
    private long createdAt;
    @Expose
    private boolean keepForever;
    @Expose
    private Long sentToServerTimestamp;

    public static InternalBeaconAction from(BeaconEvent beaconEvent) {
        InternalBeaconAction value = new InternalBeaconAction();
        value.setCreatedAt(beaconEvent.getResolvedTime());
        if (beaconEvent.sendOnlyOnce || beaconEvent.getSuppressionTimeMillis() > 0L) {
            value.setKeepForever(true);
        }
        value.setBeaconAction(BeaconAction.from(beaconEvent));
        value.setSentToServerTimestamp(null);
        return value;
    }

    public BeaconAction getBeaconAction() {
        return this.beaconAction;
    }

    public void setBeaconAction(BeaconAction beaconAction) {
        this.beaconAction = beaconAction;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean isKeepForever() {
        return this.keepForever;
    }

    public void setKeepForever(boolean keepForever) {
        this.keepForever = keepForever;
    }

    public Long getSentToServerTimestamp() {
        return this.sentToServerTimestamp;
    }

    public void setSentToServerTimestamp(Long sentToServerTimestamp) {
        this.sentToServerTimestamp = sentToServerTimestamp;
    }
}

