/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.resolver.BeaconEvent;

public class BeaconAction {
    @Expose
    @SerializedName(value="eid")
    private String actionId;
    @Expose
    @SerializedName(value="dt")
    private long timeOfPresentation;
    @Expose
    @SerializedName(value="trigger")
    private int trigger;
    @Expose
    @SerializedName(value="pid")
    private String pid;

    public static BeaconAction from(BeaconEvent beaconEvent) {
        BeaconAction value = new BeaconAction();
        value.setActionId(beaconEvent.getAction().getUuid().toString());
        value.setTimeOfPresentation(beaconEvent.getPresentationTime());
        value.setTrigger(beaconEvent.trigger);
        if (beaconEvent.getBeaconId() != null) {
            value.setPid(beaconEvent.getBeaconId().getPid());
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconAction that = (BeaconAction)o;
        if (this.timeOfPresentation != that.timeOfPresentation) {
            return false;
        }
        if (this.trigger != that.trigger) {
            return false;
        }
        if (!this.actionId.equals(that.actionId)) {
            return false;
        }
        return !(this.pid == null ? that.pid != null : !this.pid.equals(that.pid));
    }

    public int hashCode() {
        int result = this.actionId.hashCode();
        result = 31 * result + (int)(this.timeOfPresentation ^ this.timeOfPresentation >>> 32);
        result = 31 * result + this.trigger;
        result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
        return result;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public long getTimeOfPresentation() {
        return this.timeOfPresentation;
    }

    public void setTimeOfPresentation(long timeOfPresentation) {
        this.timeOfPresentation = timeOfPresentation;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }
}

