/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.sugarorm;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.Expose;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.model.ISO8601TypeAdapter;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorbergorm.SugarRecord;
import com.sensorbergorm.query.Condition;
import com.sensorbergorm.query.Select;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class SugarAction
extends SugarRecord {
    @Expose
    private String actionId;
    @Expose
    private long timeOfPresentation;
    @Expose
    private long sentToServerTimestamp;
    @Expose
    private long sentToServerTimestamp2;
    @Expose
    private long createdAt;
    @Expose
    private int trigger;
    @Expose
    private String pid;
    @Expose
    private boolean keepForever;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public long getTimeOfPresentation() {
        return this.timeOfPresentation;
    }

    public void setTimeOfPresentation(long timeOfPresentation) {
        this.timeOfPresentation = timeOfPresentation;
    }

    @Deprecated
    public long getSentToServerTimestamp() {
        return this.sentToServerTimestamp;
    }

    @Deprecated
    public void setSentToServerTimestamp(long sentToServerTimestamp) {
        this.sentToServerTimestamp = sentToServerTimestamp;
    }

    public void setSentToServerTimestamp2(long sentToServerTimestamp2) {
        this.sentToServerTimestamp2 = sentToServerTimestamp2;
    }

    public long getSentToServerTimestamp2() {
        return this.sentToServerTimestamp2;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getPid() {
        return this.pid;
    }

    public void setKeepForever(boolean keepForever) {
        this.keepForever = keepForever;
    }

    public boolean getKeepForever() {
        return this.keepForever;
    }

    public static SugarAction from(BeaconEvent beaconEvent, Clock clock) {
        SugarAction value = new SugarAction();
        value.setActionId(beaconEvent.getAction().getUuid().toString());
        value.setTimeOfPresentation(beaconEvent.getPresentationTime());
        value.setSentToServerTimestamp2(Long.MIN_VALUE);
        value.setCreatedAt(clock.now());
        value.setTrigger(beaconEvent.trigger);
        if (beaconEvent.getBeaconId() != null) {
            value.setPid(beaconEvent.getBeaconId().getBid());
        }
        if (beaconEvent.sendOnlyOnce || beaconEvent.getSuppressionTimeMillis() > 0L) {
            value.setKeepForever(true);
        }
        return value;
    }

    public static List<SugarAction> notSentScans() {
        return Select.from(SugarAction.class).where(new Condition[]{Condition.prop((String)"SENT_TO_SERVER_TIMESTAMP2").eq((Object)Long.MIN_VALUE)}).list();
    }

    public static boolean getCountForSuppressionTime(long lastAllowedPresentationTime, UUID actionUUID) {
        Select select = Select.from(SugarAction.class).where(new Condition[]{Condition.prop((String)"TIME_OF_PRESENTATION").gtOrEq((Object)lastAllowedPresentationTime)}).and(new Condition[]{Condition.prop((String)"ACTION_ID").eq((Object)actionUUID)});
        SugarAction.keepForever((Select<SugarAction>)select);
        return select.count() > 0L;
    }

    private static void keepForever(Select<SugarAction> sugarActionSelect) {
        if (sugarActionSelect.count() > 0L) {
            List values = sugarActionSelect.list();
            for (int i = 0; i < values.size(); ++i) {
                ((SugarAction)((Object)values.get(i))).setKeepForever(true);
            }
            SugarRecord.saveInTx((Collection)values);
        }
    }

    public static boolean getCountForShowOnlyOnceSuppression(UUID actionUUID) {
        Select select = Select.from(SugarAction.class).where(new Condition[]{Condition.prop((String)"ACTION_ID").eq((Object)actionUUID)});
        SugarAction.keepForever((Select<SugarAction>)select);
        return select.count() > 0L;
    }

    public static void markAsSent(List<SugarAction> actions, long now, long actionCacheTtl) {
        if (actions.size() > 0) {
            for (int i = actions.size() - 1; i >= 0; --i) {
                actions.get(i).setSentToServerTimestamp2(now);
                actions.get(i).save();
            }
        }
        SugarAction.removeAllOlderThan(now, actionCacheTtl);
    }

    public static void removeAllOlderThan(long now, long time) {
        List actionsToDelete = Select.from(SugarAction.class).where(new Condition[]{Condition.prop((String)"CREATED_AT").lt((Object)(now - time))}).and(new Condition[]{Condition.prop((String)"KEEP_FOREVER").eq((Object)false)}).and(new Condition[]{Condition.prop((String)"SENT_TO_SERVER_TIMESTAMP2").notEq((Object)Long.MIN_VALUE)}).list();
        if (actionsToDelete.size() > 0) {
            for (int i = actionsToDelete.size() - 1; i >= 0; --i) {
                ((SugarAction)((Object)actionsToDelete.get(i))).delete();
            }
        }
    }

    public static class SugarActionTypeAdapter
    extends TypeAdapter<SugarAction> {
        public void write(JsonWriter out, SugarAction value) throws IOException {
            out.beginObject();
            out.name("eid").value(value.getActionId());
            out.name("trigger").value((long)value.getTrigger());
            out.name("pid").value(value.getPid());
            out.name("dt");
            ISO8601TypeAdapter.DATE_ADAPTER.write(out, (Object)new Date(value.getTimeOfPresentation()));
            out.endObject();
        }

        public SugarAction read(JsonReader in) throws IOException {
            throw new IllegalArgumentException("You must not use this to read a RealmAction");
        }
    }
}

