/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal.transport;

import android.content.Context;
import com.google.gson.Gson;
import com.sensorberg.sdk.internal.URLFactory;
import com.sensorberg.sdk.internal.interfaces.PlatformIdentifier;
import com.sensorberg.sdk.internal.transport.interfaces.RetrofitApiService;
import com.sensorberg.sdk.internal.transport.model.HistoryBody;
import com.sensorberg.sdk.internal.transport.model.SettingsResponse;
import com.sensorberg.sdk.model.server.BaseResolveResponse;
import com.sensorberg.sdk.model.server.ResolveResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Url;

public class RetrofitApiServiceImpl
implements PlatformIdentifier.DeviceInstallationIdentifierChangeListener,
PlatformIdentifier.AdvertiserIdentifierChangeListener {
    private static final int CONNECTION_TIMEOUT = 30;
    private static final long HTTP_RESPONSE_DISK_CACHE_MAX_SIZE = 0x500000L;
    protected final Context mContext;
    private final Gson mGson;
    private final PlatformIdentifier mPlatformIdentifier;
    private final String mBaseUrl;
    private String mApiToken;
    private HttpLoggingInterceptor.Level mApiServiceLogLevel = HttpLoggingInterceptor.Level.NONE;
    private RetrofitApiService mApiService;
    private Interceptor headerAuthorizationInterceptor = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Headers.Builder headersBuilder = request.headers().newBuilder().add("User-Agent", RetrofitApiServiceImpl.this.mPlatformIdentifier.getUserAgentString()).add("X-iid", RetrofitApiServiceImpl.this.mPlatformIdentifier.getDeviceInstallationIdentifier());
            if (RetrofitApiServiceImpl.this.mPlatformIdentifier.getAdvertiserIdentifier() != null) {
                headersBuilder.add("X-aid", RetrofitApiServiceImpl.this.mPlatformIdentifier.getAdvertiserIdentifier());
            }
            if (RetrofitApiServiceImpl.this.mApiToken != null) {
                headersBuilder.add("Authorization", RetrofitApiServiceImpl.this.mApiToken).add("X-Api-Key", RetrofitApiServiceImpl.this.mApiToken);
            }
            request = request.newBuilder().headers(headersBuilder.build()).build();
            return chain.proceed(request);
        }
    };

    public RetrofitApiServiceImpl(Context ctx, Gson gson, PlatformIdentifier platformId, String baseUrl) {
        this.mContext = ctx;
        this.mGson = gson;
        this.mPlatformIdentifier = platformId;
        this.mBaseUrl = !baseUrl.endsWith("/") ? baseUrl + "/" : baseUrl;
        platformId.addAdvertiserIdentifierChangeListener(this);
        platformId.addDeviceInstallationIdentifierChangeListener(this);
    }

    private RetrofitApiService getApiService() {
        if (this.mApiService == null) {
            Retrofit restAdapter = new Retrofit.Builder().baseUrl(this.mBaseUrl).client(this.getOkHttpClient(this.mContext)).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.mGson)).build();
            this.mApiService = (RetrofitApiService)restAdapter.create(RetrofitApiService.class);
        }
        return this.mApiService;
    }

    protected OkHttpClient getOkHttpClient(Context context) {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder();
        okClientBuilder.addInterceptor(this.headerAuthorizationInterceptor);
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(this.mApiServiceLogLevel);
        okClientBuilder.addInterceptor((Interceptor)httpLoggingInterceptor);
        okClientBuilder.retryOnConnectionFailure(true);
        File baseDir = context.getCacheDir();
        if (baseDir != null) {
            File cacheDir = new File(baseDir, "HttpResponseCache");
            okClientBuilder.cache(new Cache(cacheDir, 0x500000L));
        }
        okClientBuilder.connectTimeout(30L, TimeUnit.SECONDS);
        okClientBuilder.readTimeout(30L, TimeUnit.SECONDS);
        okClientBuilder.writeTimeout(30L, TimeUnit.SECONDS);
        return okClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggingEnabled(boolean enabled) {
        Gson gson = this.mGson;
        synchronized (gson) {
            this.mApiServiceLogLevel = enabled ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE;
            if (this.mApiService != null) {
                this.mApiService = null;
            }
        }
    }

    public Call<BaseResolveResponse> updateBeaconLayout(@Url String beaconLayoutUrl) {
        return this.getApiService().updateBeaconLayout(beaconLayoutUrl);
    }

    public Call<ResolveResponse> getBeacon(@Url String beaconURLString, @Header(value="X-pid") String beaconId, @Header(value="X-qos") String networkInfo) {
        return this.getApiService().getBeacon(beaconURLString, beaconId, networkInfo);
    }

    public Call<ResolveResponse> publishHistory(@Url String beaconLayoutUrl, @Body HistoryBody body) {
        return this.getApiService().publishHistory(beaconLayoutUrl, body);
    }

    public Call<SettingsResponse> getSettings() {
        return this.getSettings(URLFactory.getSettingsURLString(this.mApiToken));
    }

    public Call<SettingsResponse> getSettings(@Url String url) {
        return this.getApiService().getSettings(url);
    }

    @Override
    public void advertiserIdentifierChanged(String advertiserIdentifier) {
    }

    @Override
    public void deviceInstallationIdentifierChanged(String deviceInstallationIdentifier) {
    }

    public void setApiToken(String mApiToken) {
        this.mApiToken = mApiToken;
    }
}

