/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm;

import android.content.Context;
import com.sensorbergorm.SugarDb;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class SugarContext {
    private static SugarContext instance = null;
    private SugarDb sugarDb;
    private Map<Object, Long> entitiesMap;

    private SugarContext(Context context) {
        this.sugarDb = new SugarDb(context);
        this.entitiesMap = Collections.synchronizedMap(new WeakHashMap());
    }

    private SugarContext(Context context, String database, int databaseVersion) {
        this.sugarDb = new SugarDb(context, database, databaseVersion);
        this.entitiesMap = Collections.synchronizedMap(new WeakHashMap());
    }

    public static SugarContext getSugarContext() {
        if (instance == null) {
            throw new NullPointerException("SugarContext has not been initialized properly. Call SugarContext.init(Context) in your Application.onCreate() method and SugarContext.terminate() in your Application.onTerminate() method.");
        }
        return instance;
    }

    public static void init(Context context) {
        instance = new SugarContext(context);
    }

    public static void initTest(Context context, String databaseName, int databaseVersion) {
        instance = new SugarContext(context, databaseName, databaseVersion);
    }

    public static void terminate() {
        if (instance == null) {
            return;
        }
        instance.doTerminate();
    }

    private void doTerminate() {
        if (this.sugarDb != null) {
            this.sugarDb.getDB().close();
        }
    }

    protected SugarDb getSugarDb() {
        return this.sugarDb;
    }

    Map<Object, Long> getEntitiesMap() {
        return this.entitiesMap;
    }
}

