/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.net.Uri;
import android.os.Build;

public class URLFactory {
    private static final String PRODUCTION_BASE_URL = "connect.sensorberg.com";
    private static final String PRODUCTION_RESOLVER_URL = "https://resolver.sensorberg.com/layout/";
    private static String SCHEME = "https";
    private static String customResolverURL = "https://resolver.sensorberg.com/layout/";

    private static Uri.Builder BaseUri() {
        return new Uri.Builder().scheme(SCHEME).encodedAuthority(PRODUCTION_BASE_URL).appendPath("api");
    }

    public static String getPingURL() {
        return URLFactory.BaseUri().appendEncodedPath("status/version").build().toString();
    }

    public static String getSettingsURLString(String apiKey) {
        return URLFactory.getSettingsURLString(null, apiKey);
    }

    public static String getSettingsURLString(Long revision, String apiKey) {
        Uri.Builder builder = URLFactory.BaseUri().appendEncodedPath("applications/").appendPath(apiKey).appendPath("settings").appendPath("android").appendPath("2.0.0").appendPath(Build.VERSION.RELEASE).appendPath(Build.MANUFACTURER).appendPath(Build.MODEL + ":" + Build.PRODUCT);
        if (revision != null) {
            builder.appendQueryParameter("revision", revision.toString());
        }
        return builder.toString();
    }

    public static String getResolveURLString() {
        if (customResolverURL != null) {
            return customResolverURL;
        }
        return URLFactory.BaseUri().appendPath("layout/").toString();
    }

    public static void setLayoutURL(String newResolverURL) {
        customResolverURL = newResolverURL != null ? newResolverURL : PRODUCTION_RESOLVER_URL;
    }
}

