/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm.query;

import android.database.Cursor;
import com.sensorbergorm.SugarRecord;
import com.sensorbergorm.query.Condition;
import com.sensorbergorm.util.NamingHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Select<T>
implements Iterable {
    private Class<T> record;
    private String[] arguments;
    private String whereClause = "";
    private String orderBy = "";
    private String groupBy = "";
    private String limit = "";
    private String offset = "";
    private List<Object> args = new ArrayList<Object>();
    private static final String SPACE = " ";
    private static final String SINGLE_QUOTE = "'";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String WHERE = "WHERE ";
    private static final String ORDER_BY = "ORDER BY ";
    private static final String GROUP_BY = "GROUP BY ";
    private static final String LIMIT = "LIMIT ";
    private static final String OFFSET = "OFFSET ";

    public Select(Class<T> record) {
        this.record = record;
    }

    public static <T> Select<T> from(Class<T> record) {
        return new Select<T>(record);
    }

    public Select<T> orderBy(String prop) {
        this.orderBy = prop;
        return this;
    }

    public Select<T> groupBy(String prop) {
        this.groupBy = prop;
        return this;
    }

    public Select<T> limit(String limit) {
        this.limit = limit;
        return this;
    }

    public Select<T> offset(String offset) {
        this.offset = offset;
        return this;
    }

    public Select<T> where(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public Select<T> where(Condition ... condition) {
        this.mergeConditions(condition, Condition.Type.AND);
        return this;
    }

    private void mergeConditions(Condition[] conditions, Condition.Type type) {
        StringBuilder toAppend = new StringBuilder();
        for (Condition condition : conditions) {
            if (toAppend.length() != 0) {
                toAppend.append(SPACE).append(type.name()).append(SPACE);
            }
            if (Condition.Check.LIKE.equals((Object)condition.getCheck()) || Condition.Check.NOT_LIKE.equals((Object)condition.getCheck())) {
                toAppend.append(condition.getProperty()).append(condition.getCheckSymbol()).append(SINGLE_QUOTE).append(condition.getValue().toString()).append(SINGLE_QUOTE);
                continue;
            }
            if (Condition.Check.IS_NULL.equals((Object)condition.getCheck()) || Condition.Check.IS_NOT_NULL.equals((Object)condition.getCheck())) {
                toAppend.append(condition.getProperty()).append(condition.getCheckSymbol());
                continue;
            }
            toAppend.append(condition.getProperty()).append(condition.getCheckSymbol()).append("? ");
            this.args.add(condition.getValue());
        }
        if (!this.whereClause.isEmpty()) {
            this.whereClause = this.whereClause + SPACE + type.name() + SPACE;
        }
        this.whereClause = this.whereClause + LEFT_PARENTHESIS + toAppend + RIGHT_PARENTHESIS;
    }

    public Select<T> whereOr(Condition ... args) {
        this.mergeConditions(args, Condition.Type.OR);
        return this;
    }

    public Select<T> and(Condition ... args) {
        this.mergeConditions(args, Condition.Type.AND);
        return this;
    }

    public Select<T> or(Condition ... args) {
        this.mergeConditions(args, Condition.Type.OR);
        return this;
    }

    public Select<T> where(String whereClause, String[] args) {
        this.whereClause = whereClause;
        this.arguments = args;
        return this;
    }

    public Cursor getCursor() {
        return SugarRecord.getCursor(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }

    public List<T> list() {
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return SugarRecord.find(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }

    public long count() {
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return SugarRecord.count(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }

    public T first() {
        List<T> list;
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return (list = SugarRecord.find(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, "1")).size() > 0 ? (T)list.get(0) : null;
    }

    String toSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(SELECT_FROM).append(NamingHelper.toSQLName(this.record)).append(SPACE);
        if (!this.whereClause.isEmpty()) {
            sql.append(WHERE).append(this.whereClause).append(SPACE);
        }
        if (!this.orderBy.isEmpty()) {
            sql.append(ORDER_BY).append(this.orderBy).append(SPACE);
        }
        if (!this.groupBy.isEmpty()) {
            sql.append(GROUP_BY).append(this.groupBy).append(SPACE);
        }
        if (!this.limit.isEmpty()) {
            sql.append(LIMIT).append(this.limit).append(SPACE);
        }
        if (!this.offset.isEmpty()) {
            sql.append(OFFSET).append(this.offset).append(SPACE);
        }
        return sql.toString();
    }

    String getWhereCond() {
        return this.whereClause;
    }

    String[] getArgs() {
        return this.convertArgs(this.args);
    }

    private String[] convertArgs(List<Object> argsList) {
        String[] argsArray = new String[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            argsArray[i] = argsList.get(i).toString();
        }
        return argsArray;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return SugarRecord.findAsIterator(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }
}

