/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.model.BeaconId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LatestBeacons {
    public static Collection<BeaconId> getLatestBeacons(Context context, long duration, TimeUnit timeUnit) {
        return LatestBeacons.getLatestBeacons(context, duration, timeUnit, 5L, TimeUnit.SECONDS);
    }

    public static Collection<BeaconId> getLatestBeacons(Context context, long duration, TimeUnit timeUnit, long timeoutduration, TimeUnit timeoutTimeUnit) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IllegalArgumentException("Calling this from your main thread can lead to deadlock");
        }
        LooperThread thread = new LooperThread(new CountDownLatch(1));
        thread.start();
        thread.waitUntilReady();
        Messenger messenger = new Messenger((Handler)thread.handler);
        Intent intent = new Intent(context, SensorbergService.class);
        intent.putExtra("com.sensorberg.android.sdk.message.list_of_beacons.messenger", (Parcelable)messenger);
        intent.putExtra("com.sensorberg.android.sdk.message.list_of_beacons.time", timeUnit.toMillis(duration));
        intent.putExtra("com.sensorberg.android.sdk.intent.generic.type", 201);
        context.startService(intent);
        try {
            if (thread.latch.await(timeoutduration, timeoutTimeUnit)) {
                thread.quit();
                return thread.handler.beaconIds;
            }
            throw new TimeoutException("The inter process communication timed out. Timeout was set to " + timeoutTimeUnit.toMillis(duration) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    static class IncomingHandler
    extends Handler {
        private final CountDownLatch latch;
        public ArrayList<BeaconId> beaconIds;

        public IncomingHandler(Looper looper, CountDownLatch latch) {
            super(looper);
            this.latch = latch;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 201: {
                    Bundle bundle = message.getData();
                    bundle.setClassLoader(BeaconId.class.getClassLoader());
                    this.beaconIds = bundle.getParcelableArrayList("com.sensorberg.android.sdk.message.list_of_beacons.beacon_ids");
                    this.latch.countDown();
                    break;
                }
                default: {
                    super.handleMessage(message);
                }
            }
        }
    }

    static class LooperThread
    extends HandlerThread {
        final CountDownLatch latch;
        IncomingHandler handler;

        LooperThread(CountDownLatch latch) {
            super("LatestBeacons thread");
            this.latch = latch;
        }

        public synchronized void waitUntilReady() {
            this.handler = new IncomingHandler(this.getLooper(), this.latch);
        }
    }
}

