/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.content.Context;
import android.os.Message;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.model.sugarorm.SugarAction;
import com.sensorberg.sdk.model.sugarorm.SugarScan;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScannerListener;
import com.sensorberg.sdk.settings.SettingsManager;
import java.util.List;

public class BeaconActionHistoryPublisher
implements ScannerListener,
RunLoop.MessageHandlerCallback {
    private static final int MSG_SCAN_EVENT = 2;
    private static final int MSG_MARK_SCANS_AS_SENT = 3;
    private static final int MSG_PUBLISH_HISTORY = 1;
    private static final int MSG_ACTION = 4;
    private static final int MSG_MARK_ACTIONS_AS_SENT = 5;
    private static final int MSG_DELETE_ALL_DATA = 6;
    private Context context;
    private Clock clock;
    private final RunLoop runloop;
    private final Transport transport;
    private ResolverListener resolverListener = ResolverListener.NONE;
    private final SettingsManager settingsManager;

    public BeaconActionHistoryPublisher(Context ctx, Transport transport, SettingsManager settingsManager, Clock clock, HandlerManager handlerManager) {
        this.context = ctx;
        this.settingsManager = settingsManager;
        this.transport = transport;
        this.clock = clock;
        this.runloop = handlerManager.getBeaconPublisherRunLoop(this);
    }

    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        this.runloop.sendMessage(2, scanEvent);
    }

    @Override
    public void handleMessage(Message queueEvent) {
        long now = this.clock.now();
        switch (queueEvent.what) {
            case 2: {
                SugarScan scan = SugarScan.from((ScanEvent)queueEvent.obj, this.clock.now());
                scan.save();
                break;
            }
            case 3: {
                List scans = (List)queueEvent.obj;
                SugarScan.maskAsSent(scans, now, this.settingsManager.getCacheTtl());
                break;
            }
            case 5: {
                List actions = (List)queueEvent.obj;
                SugarAction.markAsSent(actions, now, this.settingsManager.getCacheTtl());
                break;
            }
            case 1: {
                this.publishHistorySynchronously();
                break;
            }
            case 4: {
                SugarAction sugarAction = SugarAction.from((BeaconEvent)queueEvent.obj, this.clock);
                sugarAction.save();
                break;
            }
            case 6: {
                SugarAction.deleteAll(SugarAction.class);
                SugarScan.deleteAll(SugarScan.class);
            }
        }
    }

    private void publishHistorySynchronously() {
        List<SugarScan> scans = SugarScan.notSentScans();
        List<SugarAction> actions = SugarAction.notSentScans();
        if (scans.isEmpty() && actions.isEmpty()) {
            Logger.log.verbose("nothing to report");
            return;
        }
        this.transport.publishHistory(scans, actions, new TransportHistoryCallback(){

            @Override
            public void onSuccess(List<SugarScan> scanObjectList, List<SugarAction> actionList) {
                BeaconActionHistoryPublisher.this.runloop.sendMessage(3, scanObjectList);
                BeaconActionHistoryPublisher.this.runloop.sendMessage(5, actionList);
            }

            @Override
            public void onFailure(Exception throwable) {
                Logger.log.logError("not able to publish history", throwable);
            }

            @Override
            public void onInstantActions(List<BeaconEvent> instantActions) {
                BeaconActionHistoryPublisher.this.resolverListener.onResolutionsFinished(instantActions);
            }
        });
    }

    public void publishHistory() {
        this.runloop.add(this.runloop.obtainMessage(1));
    }

    public void onActionPresented(BeaconEvent beaconEvent) {
        this.runloop.sendMessage(4, beaconEvent);
    }

    public void deleteAllObjects() {
        this.runloop.sendMessage(6);
    }

    public void setResolverListener(ResolverListener resolverListener) {
        this.resolverListener = resolverListener;
    }
}

