/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.resolver;

import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.BeaconResponseHandler;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolutionConfiguration;
import com.sensorberg.sdk.resolver.Resolver;
import java.util.List;

public class Resolution {
    public final ResolutionConfiguration configuration;
    private final Resolver resolver;
    private final Transport transport;

    Resolution(Resolver resolver, ResolutionConfiguration configuration, Transport transport) {
        this.transport = transport;
        this.configuration = configuration;
        this.resolver = resolver;
    }

    public void queryServer() {
        Logger.log.beaconResolveState(this.configuration.getScanEvent(), "starting to resolve request");
        this.transport.getBeacon(this.configuration, new BeaconResponseHandler(){

            @Override
            public void onSuccess(List<BeaconEvent> beaconEvents) {
                Resolution.this.resolver.onResolutionFinished(Resolution.this, beaconEvents);
                for (BeaconEvent beaconEvent : beaconEvents) {
                    Logger.log.beaconResolveState(Resolution.this.configuration.getScanEvent(), "success resolving action:" + beaconEvent.getAction());
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                Logger.log.beaconResolveState(Resolution.this.configuration.getScanEvent(), "failure resolving throwable:" + throwable.getMessage());
                Resolution.this.resolver.onResolutionFailed(Resolution.this, throwable);
            }
        });
    }

    public void start() {
        this.resolver.startResolution(this);
    }
}

