/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.action;

import android.net.Uri;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.InAppAction;
import com.sensorberg.sdk.action.UriMessageAction;
import com.sensorberg.sdk.action.VisitWebsiteAction;
import com.sensorberg.sdk.model.ISO8601TypeAdapter;
import com.sensorberg.sdk.model.sugarorm.SugarAction;
import com.sensorberg.sdk.model.sugarorm.SugarScan;
import java.util.Date;
import java.util.UUID;
import org.json.JSONException;

public class ActionFactory {
    private static Gson gson;
    private static final String SUBJECT = "subject";
    private static final String BODY = "body";
    private static final String URL = "url";
    private static final String DELAY_TIME = "delayTime";
    private static final String CONTENT = "content";
    private static final String TYPE = "type";
    private static final String PAYLOAD = "payload";

    public static Action actionFromJSONObject(JsonObject contentJSON) throws JSONException {
        int actionType = contentJSON.get(TYPE).getAsInt();
        UUID actionUUID = UUID.fromString(contentJSON.get("id").getAsString());
        long delayMilliseconds = (contentJSON.get(DELAY_TIME) != null ? contentJSON.get(DELAY_TIME).getAsLong() : 0L) * 1000L;
        String messageString = contentJSON.get(CONTENT).getAsString();
        JsonParser parser = new JsonParser();
        JsonObject message = parser.parse(messageString).getAsJsonObject();
        return ActionFactory.getAction(actionType, message, actionUUID, delayMilliseconds);
    }

    public static Action getAction(int actionType, JsonObject message, UUID actionUUID, long delay) throws JSONException {
        if (message == null) {
            return null;
        }
        Action value = null;
        String payload = null;
        JsonElement payloadElement = message.get(PAYLOAD);
        if (payloadElement != null && !payloadElement.isJsonNull()) {
            payload = payloadElement.isJsonArray() || payloadElement.isJsonObject() ? ActionFactory.getGson().toJson(message.get(PAYLOAD)) : payloadElement.getAsString();
        }
        String subject = message.get(SUBJECT) == null ? null : message.get(SUBJECT).getAsString();
        String body = message.get(BODY) == null ? null : message.get(BODY).getAsString();
        switch (actionType) {
            case 1: {
                value = new UriMessageAction(actionUUID, subject, body, message.get(URL).getAsString(), payload, delay);
                break;
            }
            case 2: {
                value = new VisitWebsiteAction(actionUUID, subject, body, Uri.parse((String)message.get(URL).getAsString()), payload, delay);
                break;
            }
            case 3: {
                value = new InAppAction(actionUUID, subject, body, payload, Uri.parse((String)message.get(URL).getAsString()), delay);
            }
        }
        return value;
    }

    private static Gson getGson() {
        if (gson == null) {
            gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Date.class, ISO8601TypeAdapter.DATE_ADAPTER).registerTypeAdapter(SugarScan.class, (Object)new SugarScan.SugarScanObjectTypeAdapter()).registerTypeAdapter(SugarAction.class, (Object)new SugarAction.SugarActionTypeAdapter()).setLenient().create();
        }
        return gson;
    }

    public static interface ServerType {
        public static final int URL_MESSAGE = 1;
        public static final int VISIT_WEBSITE = 2;
        public static final int IN_APP = 3;
    }
}

