/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Collection {
    public static <T> List<T> list(T ... args) {
        return Arrays.asList(args);
    }

    public static <T> Set<T> set(T ... args) {
        HashSet<T> result = new HashSet<T>(args.length);
        result.addAll(Arrays.asList(args));
        return result;
    }

    public static <K, V> Map<K, V> map(Entry<? extends K, ? extends V> ... entries) {
        HashMap result = new HashMap(entries.length);
        for (Entry<? extends K, ? extends V> entry : entries) {
            if (entry.value == null) continue;
            result.put(entry.key, entry.value);
        }
        return result;
    }

    public static <K, V> Entry<K, V> entry(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    public static class Entry<K, V> {
        K key;
        V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

