/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.util.ArrayList;
import java.util.List;

public class NetworkInfoBroadcastReceiver
extends BroadcastReceiver {
    public static NetworkInfo latestNetworkInfo = null;
    public static final List<NetworkInfoListener> listener = new ArrayList<NetworkInfoListener>();
    public static NotificationBuilder notificationBuilder = NotificationBuilder.NONE;

    public void onReceive(Context context, Intent intent) {
        NetworkInfoBroadcastReceiver.triggerListenerWithCurrentState(context);
    }

    public static String infoToString(NetworkInfo networkInfoMaybeNull) {
        if (networkInfoMaybeNull == null) {
            return "not connected";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Connected: ").append(networkInfoMaybeNull.isConnected()).append('\n');
        builder.append("ConnectedOrConnecting: ").append(networkInfoMaybeNull.isConnectedOrConnecting()).append('\n');
        builder.append("State: ").append(networkInfoMaybeNull.getState()).append('\n');
        builder.append("Extra Info: ").append(networkInfoMaybeNull.getExtraInfo()).append('\n');
        builder.append("Sub type name: ").append(networkInfoMaybeNull.getSubtypeName()).append('\n');
        builder.append("Sub type: ").append(networkInfoMaybeNull.getSubtype()).append('\n');
        builder.append("Reason: ").append(networkInfoMaybeNull.getReason()).append('\n');
        builder.append("Type name: ").append(networkInfoMaybeNull.getTypeName()).append('\n');
        builder.append("Type: ").append(NetworkInfoBroadcastReceiver.typeToString(networkInfoMaybeNull.getType())).append('\n');
        return builder.toString();
    }

    private static String typeToString(int type) {
        switch (type) {
            case 9: {
                return "TYPE_ETHERNET";
            }
            case 7: {
                return "TYPE_BLUETOOTH";
            }
            case 0: {
                return "TYPE_MOBILE";
            }
            case 4: {
                return "TYPE_MOBILE_DUN";
            }
            case 5: {
                return "TYPE_MOBILE_HIPRI";
            }
            case 2: {
                return "TYPE_MOBILE_MMS";
            }
            case 3: {
                return "TYPE_MOBILE_SUPL";
            }
            case 17: {
                return "TYPE_VPN";
            }
            case 1: {
                return "TYPE_WIFI";
            }
            case 6: {
                return "TYPE_WIMAX";
            }
        }
        return "unknown";
    }

    public static void triggerListenerWithCurrentState(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        latestNetworkInfo = manager.getActiveNetworkInfo();
        for (NetworkInfoListener networkInfoListener : listener) {
            networkInfoListener.onNetworkInfoChanged(latestNetworkInfo);
        }
        notificationBuilder.buildNotification(context, latestNetworkInfo);
    }

    public static String getNetworkInfoString() {
        if (latestNetworkInfo == null) {
            return "unknown";
        }
        switch (latestNetworkInfo.getType()) {
            case 9: {
                return "lan";
            }
            case 0: {
                return latestNetworkInfo.getSubtypeName().toLowerCase();
            }
            case 1: {
                return "wifi";
            }
        }
        return "unknown";
    }

    public static interface NotificationBuilder {
        public static final NotificationBuilder NONE = new NotificationBuilder(){

            @Override
            public void buildNotification(Context context, NetworkInfo latestNetworkInfo) {
            }
        };

        public void buildNotification(Context var1, NetworkInfo var2);
    }

    public static interface NetworkInfoListener {
        public void onNetworkInfoChanged(NetworkInfo var1);
    }
}

