/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScanEventType;

public class BeaconScan {
    public static final String SHARED_PREFS_TAG = "BeaconScans";
    public static final long NO_DATE = Long.MIN_VALUE;
    @Expose
    private long eventTime;
    @Expose
    private boolean isEntry;
    @Expose
    private String proximityUUID;
    @Expose
    private int proximityMajor;
    @Expose
    private int proximityMinor;
    @Expose
    private long sentToServerTimestamp2;
    @Expose
    private long createdAt;

    public int getTrigger() {
        return this.isEntry() ? ScanEventType.ENTRY.getMask() : ScanEventType.EXIT.getMask();
    }

    public String getPid() {
        return this.getProximityUUID().replace("-", "") + String.format("%1$05d%2$05d", this.getProximityMajor(), this.getProximityMinor());
    }

    public static BeaconScan from(ScanEvent scanEvent, long timeNow) {
        BeaconScan value = new BeaconScan();
        value.setEventTime(scanEvent.getEventTime());
        value.setEntry(scanEvent.getEventMask() == ScanEventType.ENTRY.getMask());
        value.setProximityUUID(scanEvent.getBeaconId().getUuid().toString());
        value.setProximityMajor(scanEvent.getBeaconId().getMajorId());
        value.setProximityMinor(scanEvent.getBeaconId().getMinorId());
        value.setSentToServerTimestamp2(Long.MIN_VALUE);
        value.setCreatedAt(timeNow);
        return value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeaconScan)) {
            return false;
        }
        BeaconScan other = (BeaconScan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEventTime() != other.getEventTime()) {
            return false;
        }
        if (this.isEntry() != other.isEntry()) {
            return false;
        }
        String this$proximityUUID = this.getProximityUUID();
        String other$proximityUUID = other.getProximityUUID();
        if (this$proximityUUID == null ? other$proximityUUID != null : !this$proximityUUID.equals(other$proximityUUID)) {
            return false;
        }
        if (this.getProximityMajor() != other.getProximityMajor()) {
            return false;
        }
        if (this.getProximityMinor() != other.getProximityMinor()) {
            return false;
        }
        if (this.getSentToServerTimestamp2() != other.getSentToServerTimestamp2()) {
            return false;
        }
        return this.getCreatedAt() == other.getCreatedAt();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeaconScan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $eventTime = this.getEventTime();
        result = result * 59 + (int)($eventTime >>> 32 ^ $eventTime);
        result = result * 59 + (this.isEntry() ? 79 : 97);
        String $proximityUUID = this.getProximityUUID();
        result = result * 59 + ($proximityUUID == null ? 0 : $proximityUUID.hashCode());
        result = result * 59 + this.getProximityMajor();
        result = result * 59 + this.getProximityMinor();
        long $sentToServerTimestamp2 = this.getSentToServerTimestamp2();
        result = result * 59 + (int)($sentToServerTimestamp2 >>> 32 ^ $sentToServerTimestamp2);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        return result;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public void setEntry(boolean isEntry) {
        this.isEntry = isEntry;
    }

    public String getProximityUUID() {
        return this.proximityUUID;
    }

    public void setProximityUUID(String proximityUUID) {
        this.proximityUUID = proximityUUID;
    }

    public int getProximityMajor() {
        return this.proximityMajor;
    }

    public void setProximityMajor(int proximityMajor) {
        this.proximityMajor = proximityMajor;
    }

    public int getProximityMinor() {
        return this.proximityMinor;
    }

    public void setProximityMinor(int proximityMinor) {
        this.proximityMinor = proximityMinor;
    }

    public long getSentToServerTimestamp2() {
        return this.sentToServerTimestamp2;
    }

    public void setSentToServerTimestamp2(long sentToServerTimestamp2) {
        this.sentToServerTimestamp2 = sentToServerTimestamp2;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }
}

