/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal.transport;

import android.util.Pair;
import com.sensorberg.sdk.internal.URLFactory;
import com.sensorberg.sdk.internal.interfaces.BeaconHistoryUploadIntervalListener;
import com.sensorberg.sdk.internal.interfaces.BeaconResponseHandler;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.transport.CallbackWithRetry;
import com.sensorberg.sdk.internal.transport.RetrofitApiServiceImpl;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.internal.transport.interfaces.TransportSettingsCallback;
import com.sensorberg.sdk.internal.transport.model.HistoryBody;
import com.sensorberg.sdk.internal.transport.model.SettingsResponse;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.model.persistence.BeaconScan;
import com.sensorberg.sdk.model.server.BaseResolveResponse;
import com.sensorberg.sdk.model.server.ResolveAction;
import com.sensorberg.sdk.model.server.ResolveResponse;
import com.sensorberg.sdk.receivers.NetworkInfoBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolutionConfiguration;
import com.sensorberg.utils.ListUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class RetrofitApiTransport
implements Transport {
    private final Clock mClock;
    private RetrofitApiServiceImpl apiService;
    private BeaconHistoryUploadIntervalListener beaconHistoryUploadIntervalListener = BeaconHistoryUploadIntervalListener.NONE;
    private Transport.ProximityUUIDUpdateHandler mProximityUUIDUpdateHandler = Transport.ProximityUUIDUpdateHandler.NONE;
    private Transport.BeaconReportHandler mBeaconReportHandler;

    public RetrofitApiTransport(RetrofitApiServiceImpl retrofitApiService, Clock clk) {
        this.apiService = retrofitApiService;
        this.mClock = clk;
    }

    private RetrofitApiServiceImpl getApiService() {
        return this.apiService;
    }

    @Override
    public void setBeaconReportHandler(Transport.BeaconReportHandler beaconReportHandler) {
        this.mBeaconReportHandler = beaconReportHandler;
    }

    @Override
    public void setProximityUUIDUpdateHandler(Transport.ProximityUUIDUpdateHandler proximityUUIDUpdateHandler) {
        this.mProximityUUIDUpdateHandler = proximityUUIDUpdateHandler != null ? proximityUUIDUpdateHandler : Transport.ProximityUUIDUpdateHandler.NONE;
    }

    @Override
    public void getBeacon(final ResolutionConfiguration resolutionConfiguration, final BeaconResponseHandler beaconResponseHandler) {
        String networkInfo = NetworkInfoBroadcastReceiver.latestNetworkInfo != null ? NetworkInfoBroadcastReceiver.getNetworkInfoString() : "";
        Call<ResolveResponse> call = this.getApiService().getBeacon(URLFactory.getResolveURLString(), resolutionConfiguration.getScanEvent().getBeaconId().getBid(), networkInfo);
        call.enqueue((Callback)new Callback<ResolveResponse>(){

            public void onResponse(Call<ResolveResponse> call, Response<ResolveResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Pair beaconEventPair = RetrofitApiTransport.this.checkSuccessfulBeaconResponse(resolutionConfiguration, (ResolveResponse)response.body());
                    beaconResponseHandler.onSuccess((List)beaconEventPair.second);
                    RetrofitApiTransport.this.checkShouldCallBeaconResponseHandlers((Boolean)beaconEventPair.first, (ResolveResponse)response.body());
                } else {
                    beaconResponseHandler.onFailure(new Throwable("No Content, Invalid Api Key"));
                }
            }

            public void onFailure(Call<ResolveResponse> call, Throwable t) {
                beaconResponseHandler.onFailure(t);
            }
        });
    }

    private void checkShouldCallBeaconResponseHandlers(boolean shouldReportImmediately, ResolveResponse successfulResponse) {
        if (shouldReportImmediately && this.mBeaconReportHandler != null) {
            this.mBeaconReportHandler.reportImmediately();
        }
        this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(successfulResponse.getAccountProximityUUIDs());
        if (successfulResponse.reportTriggerSeconds != null) {
            this.beaconHistoryUploadIntervalListener.historyUploadIntervalChanged(TimeUnit.SECONDS.toMillis(successfulResponse.reportTriggerSeconds));
        }
    }

    private Pair<Boolean, List<BeaconEvent>> checkSuccessfulBeaconResponse(ResolutionConfiguration resolutionConfiguration, ResolveResponse successfulResponse) {
        boolean reportImmediately = false;
        List<ResolveAction> resolveActions = successfulResponse.resolve(resolutionConfiguration.getScanEvent(), this.mClock.now());
        for (ResolveAction resolveAction : resolveActions) {
            reportImmediately |= resolveAction.isReportImmediately();
        }
        List<BeaconEvent> beaconEvents = ListUtils.map(resolveActions, ResolveAction.BEACON_EVENT_MAPPER);
        for (BeaconEvent beaconEvent : beaconEvents) {
            beaconEvent.setBeaconId(resolutionConfiguration.getScanEvent().getBeaconId());
        }
        return new Pair((Object)reportImmediately, beaconEvents);
    }

    @Override
    public void setApiToken(String apiToken) {
        this.getApiService().setApiToken(apiToken);
    }

    @Override
    public void loadSettings(final TransportSettingsCallback transportSettingsCallback) {
        Call<SettingsResponse> call = this.getApiService().getSettings();
        this.enqueueWithRetry(call, new Callback<SettingsResponse>(){

            public void onResponse(Call<SettingsResponse> call, Response<SettingsResponse> response) {
                if (response.isSuccessful()) {
                    if (response.code() == 204) {
                        transportSettingsCallback.onSettingsFound(null);
                    } else {
                        transportSettingsCallback.onSettingsFound((SettingsResponse)response.body());
                    }
                } else if (response.code() == 304) {
                    transportSettingsCallback.nothingChanged();
                } else {
                    transportSettingsCallback.onFailure(new Exception());
                }
            }

            public void onFailure(Call<SettingsResponse> call, Throwable t) {
                transportSettingsCallback.onFailure(new Exception(t));
            }
        });
    }

    @Override
    public void publishHistory(final List<BeaconScan> scans, final List<BeaconAction> actions, final TransportHistoryCallback callback) {
        HistoryBody body = new HistoryBody(scans, actions, this.mClock);
        Call<ResolveResponse> call = this.getApiService().publishHistory(URLFactory.getResolveURLString(), body);
        call.enqueue((Callback)new Callback<ResolveResponse>(){

            public void onResponse(Call<ResolveResponse> call, Response<ResolveResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    callback.onSuccess(scans, actions);
                    callback.onInstantActions(((ResolveResponse)response.body()).getInstantActionsAsBeaconEvent());
                } else {
                    callback.onFailure(new Exception("No Content, Invalid Api Key"));
                }
            }

            public void onFailure(Call<ResolveResponse> call, Throwable t) {
                callback.onFailure(new Exception(t));
            }
        });
    }

    @Override
    public void updateBeaconLayout() {
        Call<BaseResolveResponse> call = this.getApiService().updateBeaconLayout(URLFactory.getResolveURLString());
        call.enqueue((Callback)new Callback<BaseResolveResponse>(){

            public void onResponse(Call<BaseResolveResponse> call, Response<BaseResolveResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    RetrofitApiTransport.this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(((BaseResolveResponse)response.body()).getAccountProximityUUIDs());
                } else {
                    RetrofitApiTransport.this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(Collections.EMPTY_LIST);
                }
            }

            public void onFailure(Call<BaseResolveResponse> call, Throwable t) {
                RetrofitApiTransport.this.mProximityUUIDUpdateHandler.proximityUUIDListUpdated(Collections.EMPTY_LIST);
            }
        });
    }

    @Override
    public void setLoggingEnabled(boolean enabled) {
        this.getApiService().setLoggingEnabled(enabled);
    }

    public <T> void enqueueWithRetry(Call<T> call, Callback<T> callback) {
        call.enqueue(new CallbackWithRetry<T>(callback));
    }

    @Override
    public void setBeaconHistoryUploadIntervalListener(BeaconHistoryUploadIntervalListener beaconHistoryUploadIntervalListener) {
        this.beaconHistoryUploadIntervalListener = beaconHistoryUploadIntervalListener;
    }
}

