/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal.transport;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class CallbackWithRetry<T>
implements Callback<T> {
    private static final int TOTAL_RETRIES = 2;
    private final Callback<T> callback;
    private int retryCount = 0;

    public CallbackWithRetry(Callback<T> cbk) {
        this.callback = cbk;
    }

    private void retry(Call<T> call) {
        ++this.retryCount;
        call.clone().enqueue((Callback)this);
    }

    private boolean willRetry() {
        return this.retryCount < 2;
    }

    public void onResponse(Call<T> call, Response<T> response) {
        this.callback.onResponse(call, response);
    }

    public void onFailure(Call<T> call, Throwable t) {
        if (this.willRetry()) {
            this.retry(call);
        } else {
            this.callback.onFailure(call, t);
        }
    }
}

