/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm;

import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.sensorbergorm.SugarContext;

public class SugarTransactionHelper {
    public static void doInTransaction(Callback callback) {
        SQLiteDatabase database = SugarContext.getSugarContext().getSugarDb().getDB();
        database.beginTransaction();
        try {
            Log.d((String)SugarTransactionHelper.class.getSimpleName(), (String)"Callback executing within transaction");
            callback.manipulateInTransaction();
            database.setTransactionSuccessful();
            Log.d((String)SugarTransactionHelper.class.getSimpleName(), (String)"Callback successfully executed within transaction");
        }
        catch (Throwable e) {
            Log.d((String)SugarTransactionHelper.class.getSimpleName(), (String)"Could execute callback within transaction", (Throwable)e);
        }
        finally {
            database.endTransaction();
        }
    }

    public static interface Callback {
        public void manipulateInTransaction();
    }
}

