package io.realm;


import android.util.JsonReader;
import io.realm.exceptions.RealmException;
import io.realm.internal.RealmJson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import com.sensorberg.sdk.model.realm.RealmAction;
import com.sensorberg.sdk.model.realm.RealmScan;

class RealmJsonImpl
    implements RealmJson {

    @Override
    public <E extends RealmObject> void populateUsingJsonObject(E obj, JSONObject json)
        throws JSONException {
        String classQualifiedName = (obj.realm != null) ? obj.getClass().getSuperclass().getName() : obj.getClass().getName();
        if (classQualifiedName.equals(RealmAction.class.getName())) {
            RealmActionRealmProxy.populateUsingJsonObject((RealmAction) obj, json);
        } else if (classQualifiedName.equals(RealmScan.class.getName())) {
            RealmScanRealmProxy.populateUsingJsonObject((RealmScan) obj, json);
        } else {
            throw new RealmException("Could not find the generated proxy class for " + classQualifiedName);
        }
    }

    @Override
    public <E extends RealmObject> void populateUsingJsonStream(E obj, JsonReader reader)
        throws IOException {
        String classQualifiedName = (obj.realm != null) ? obj.getClass().getSuperclass().getName() : obj.getClass().getName();
        if (classQualifiedName.equals(RealmAction.class.getName())) {
            RealmActionRealmProxy.populateUsingJsonStream((RealmAction) obj, reader);
        } else if (classQualifiedName.equals(RealmScan.class.getName())) {
            RealmScanRealmProxy.populateUsingJsonStream((RealmScan) obj, reader);
        } else {
            throw new RealmException("Could not find the generated proxy class for " + classQualifiedName);
        }
    }

}
