package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import com.sensorberg.sdk.model.realm.RealmScan;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RealmScanRealmProxy extends RealmScan {

    @Override
    public long getEventTime() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmScan").get("eventTime"));
    }

    @Override
    public void setEventTime(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmScan").get("eventTime"), (long) value);
    }

    @Override
    public boolean isEntry() {
        realm.checkIfValid();
        return (boolean) row.getBoolean(Realm.columnIndices.get("RealmScan").get("isEntry"));
    }

    @Override
    public void setEntry(boolean value) {
        realm.checkIfValid();
        row.setBoolean(Realm.columnIndices.get("RealmScan").get("isEntry"), (boolean) value);
    }

    @Override
    public String getProximityUUID() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(Realm.columnIndices.get("RealmScan").get("proximityUUID"));
    }

    @Override
    public void setProximityUUID(String value) {
        realm.checkIfValid();
        row.setString(Realm.columnIndices.get("RealmScan").get("proximityUUID"), (String) value);
    }

    @Override
    public int getProximityMajor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("RealmScan").get("proximityMajor"));
    }

    @Override
    public void setProximityMajor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmScan").get("proximityMajor"), (long) value);
    }

    @Override
    public int getProximityMinor() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("RealmScan").get("proximityMinor"));
    }

    @Override
    public void setProximityMinor(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmScan").get("proximityMinor"), (long) value);
    }

    @Override
    public long getSentToServerTimestamp() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmScan").get("sentToServerTimestamp"));
    }

    @Override
    public void setSentToServerTimestamp(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmScan").get("sentToServerTimestamp"), (long) value);
    }

    @Override
    public long getSentToServerTimestamp2() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmScan").get("sentToServerTimestamp2"));
    }

    @Override
    public void setSentToServerTimestamp2(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmScan").get("sentToServerTimestamp2"), (long) value);
    }

    @Override
    public long getCreatedAt() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmScan").get("createdAt"));
    }

    @Override
    public void setCreatedAt(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmScan").get("createdAt"), (long) value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if(!transaction.hasTable("class_RealmScan")) {
            Table table = transaction.getTable("class_RealmScan");
            table.addColumn(ColumnType.INTEGER, "eventTime");
            table.addColumn(ColumnType.BOOLEAN, "isEntry");
            table.addColumn(ColumnType.STRING, "proximityUUID");
            table.addColumn(ColumnType.INTEGER, "proximityMajor");
            table.addColumn(ColumnType.INTEGER, "proximityMinor");
            table.addColumn(ColumnType.INTEGER, "sentToServerTimestamp");
            table.addColumn(ColumnType.INTEGER, "sentToServerTimestamp2");
            table.addColumn(ColumnType.INTEGER, "createdAt");
            table.setPrimaryKey("");
            return table;
        }
        return transaction.getTable("class_RealmScan");
    }

    public static void validateTable(ImplicitTransaction transaction) {
        if(transaction.hasTable("class_RealmScan")) {
            Table table = transaction.getTable("class_RealmScan");
            if(table.getColumnCount() != 8) {
                throw new IllegalStateException("Column count does not match");
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for(long i = 0; i < 8; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            if (!columnTypes.containsKey("eventTime")) {
                throw new IllegalStateException("Missing column 'eventTime'");
            }
            if (columnTypes.get("eventTime") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'eventTime'");
            }
            if (!columnTypes.containsKey("isEntry")) {
                throw new IllegalStateException("Missing column 'isEntry'");
            }
            if (columnTypes.get("isEntry") != ColumnType.BOOLEAN) {
                throw new IllegalStateException("Invalid type 'boolean' for column 'isEntry'");
            }
            if (!columnTypes.containsKey("proximityUUID")) {
                throw new IllegalStateException("Missing column 'proximityUUID'");
            }
            if (columnTypes.get("proximityUUID") != ColumnType.STRING) {
                throw new IllegalStateException("Invalid type 'String' for column 'proximityUUID'");
            }
            if (!columnTypes.containsKey("proximityMajor")) {
                throw new IllegalStateException("Missing column 'proximityMajor'");
            }
            if (columnTypes.get("proximityMajor") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'proximityMajor'");
            }
            if (!columnTypes.containsKey("proximityMinor")) {
                throw new IllegalStateException("Missing column 'proximityMinor'");
            }
            if (columnTypes.get("proximityMinor") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'proximityMinor'");
            }
            if (!columnTypes.containsKey("sentToServerTimestamp")) {
                throw new IllegalStateException("Missing column 'sentToServerTimestamp'");
            }
            if (columnTypes.get("sentToServerTimestamp") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'sentToServerTimestamp'");
            }
            if (!columnTypes.containsKey("sentToServerTimestamp2")) {
                throw new IllegalStateException("Missing column 'sentToServerTimestamp2'");
            }
            if (columnTypes.get("sentToServerTimestamp2") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'sentToServerTimestamp2'");
            }
            if (!columnTypes.containsKey("createdAt")) {
                throw new IllegalStateException("Missing column 'createdAt'");
            }
            if (columnTypes.get("createdAt") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'createdAt'");
            }
        }
    }

    public static List<String> getFieldNames() {
        return Arrays.asList("eventTime", "isEntry", "proximityUUID", "proximityMajor", "proximityMinor", "sentToServerTimestamp", "sentToServerTimestamp2", "createdAt");
    }

    public static void populateUsingJsonObject(RealmScan obj, JSONObject json)
        throws JSONException {
        boolean standalone = obj.realm == null;
        if (json.has("eventTime")) {
            obj.setEventTime((long) json.getLong("eventTime"));
        }
        if (json.has("isEntry")) {
            obj.setEntry((boolean) json.getBoolean("isEntry"));
        }
        if (json.has("proximityUUID")) {
            obj.setProximityUUID((String) json.getString("proximityUUID"));
        }
        if (json.has("proximityMajor")) {
            obj.setProximityMajor((int) json.getInt("proximityMajor"));
        }
        if (json.has("proximityMinor")) {
            obj.setProximityMinor((int) json.getInt("proximityMinor"));
        }
        if (json.has("sentToServerTimestamp")) {
            obj.setSentToServerTimestamp((long) json.getLong("sentToServerTimestamp"));
        }
        if (json.has("sentToServerTimestamp2")) {
            obj.setSentToServerTimestamp2((long) json.getLong("sentToServerTimestamp2"));
        }
        if (json.has("createdAt")) {
            obj.setCreatedAt((long) json.getLong("createdAt"));
        }
    }

    public static void populateUsingJsonStream(RealmScan obj, JsonReader reader)
        throws IOException {
        boolean standalone = obj.realm == null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("eventTime") && reader.peek() != JsonToken.NULL) {
                obj.setEventTime((long) reader.nextLong());
            } else if (name.equals("isEntry")  && reader.peek() != JsonToken.NULL) {
                obj.setEntry((boolean) reader.nextBoolean());
            } else if (name.equals("proximityUUID")  && reader.peek() != JsonToken.NULL) {
                obj.setProximityUUID((String) reader.nextString());
            } else if (name.equals("proximityMajor")  && reader.peek() != JsonToken.NULL) {
                obj.setProximityMajor((int) reader.nextInt());
            } else if (name.equals("proximityMinor")  && reader.peek() != JsonToken.NULL) {
                obj.setProximityMinor((int) reader.nextInt());
            } else if (name.equals("sentToServerTimestamp")  && reader.peek() != JsonToken.NULL) {
                obj.setSentToServerTimestamp((long) reader.nextLong());
            } else if (name.equals("sentToServerTimestamp2")  && reader.peek() != JsonToken.NULL) {
                obj.setSentToServerTimestamp2((long) reader.nextLong());
            } else if (name.equals("createdAt")  && reader.peek() != JsonToken.NULL) {
                obj.setCreatedAt((long) reader.nextLong());
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
    }

    public static RealmScan copyOrUpdate(Realm realm, RealmScan object, boolean update, Map<RealmObject,RealmObject> cache) {
        return copy(realm, object, update, cache);
    }

    public static RealmScan copy(Realm realm, RealmScan newObject, boolean update, Map<RealmObject,RealmObject> cache) {
        RealmScan realmObject = realm.createObject(RealmScan.class);
        cache.put(newObject, realmObject);
        realmObject.setEventTime(newObject.getEventTime());
        realmObject.setEntry(newObject.isEntry());
        realmObject.setProximityUUID(newObject.getProximityUUID() != null ? newObject.getProximityUUID() : "");
        realmObject.setProximityMajor(newObject.getProximityMajor());
        realmObject.setProximityMinor(newObject.getProximityMinor());
        realmObject.setSentToServerTimestamp(newObject.getSentToServerTimestamp());
        realmObject.setSentToServerTimestamp2(newObject.getSentToServerTimestamp2());
        realmObject.setCreatedAt(newObject.getCreatedAt());
        return realmObject;
    }

    static RealmScan update(Realm realm, RealmScan realmObject, RealmScan newObject, Map<RealmObject, RealmObject> cache) {
        realmObject.setEventTime(newObject.getEventTime());
        realmObject.setEntry(newObject.isEntry());
        realmObject.setProximityUUID(newObject.getProximityUUID() != null ? newObject.getProximityUUID() : "");
        realmObject.setProximityMajor(newObject.getProximityMajor());
        realmObject.setProximityMinor(newObject.getProximityMinor());
        realmObject.setSentToServerTimestamp(newObject.getSentToServerTimestamp());
        realmObject.setSentToServerTimestamp2(newObject.getSentToServerTimestamp2());
        realmObject.setCreatedAt(newObject.getCreatedAt());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("RealmScan = [");
        stringBuilder.append("{eventTime:");
        stringBuilder.append(getEventTime());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{isEntry:");
        stringBuilder.append(isEntry());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{proximityUUID:");
        stringBuilder.append(getProximityUUID());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{proximityMajor:");
        stringBuilder.append(getProximityMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{proximityMinor:");
        stringBuilder.append(getProximityMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{sentToServerTimestamp:");
        stringBuilder.append(getSentToServerTimestamp());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{sentToServerTimestamp2:");
        stringBuilder.append(getSentToServerTimestamp2());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{createdAt:");
        stringBuilder.append(getCreatedAt());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RealmScanRealmProxy aRealmScan = (RealmScanRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aRealmScan.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aRealmScan.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aRealmScan.row.getIndex()) return false;

        return true;
    }

}
