package io.realm;


import android.util.JsonReader;
import android.util.JsonToken;
import com.sensorberg.sdk.model.realm.RealmAction;
import io.realm.RealmObject;
import io.realm.exceptions.RealmException;
import io.realm.internal.ColumnType;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.LinkView;
import io.realm.internal.Table;
import io.realm.internal.TableOrView;
import io.realm.internal.android.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RealmActionRealmProxy extends RealmAction {

    @Override
    public String getActionId() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(Realm.columnIndices.get("RealmAction").get("actionId"));
    }

    @Override
    public void setActionId(String value) {
        realm.checkIfValid();
        row.setString(Realm.columnIndices.get("RealmAction").get("actionId"), (String) value);
    }

    @Override
    public long getTimeOfPresentation() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmAction").get("timeOfPresentation"));
    }

    @Override
    public void setTimeOfPresentation(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmAction").get("timeOfPresentation"), (long) value);
    }

    @Override
    public long getSentToServerTimestamp() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmAction").get("sentToServerTimestamp"));
    }

    @Override
    public void setSentToServerTimestamp(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmAction").get("sentToServerTimestamp"), (long) value);
    }

    @Override
    public long getCreatedAt() {
        realm.checkIfValid();
        return (long) row.getLong(Realm.columnIndices.get("RealmAction").get("createdAt"));
    }

    @Override
    public void setCreatedAt(long value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmAction").get("createdAt"), (long) value);
    }

    @Override
    public int getTrigger() {
        realm.checkIfValid();
        return (int) row.getLong(Realm.columnIndices.get("RealmAction").get("trigger"));
    }

    @Override
    public void setTrigger(int value) {
        realm.checkIfValid();
        row.setLong(Realm.columnIndices.get("RealmAction").get("trigger"), (long) value);
    }

    @Override
    public String getPid() {
        realm.checkIfValid();
        return (java.lang.String) row.getString(Realm.columnIndices.get("RealmAction").get("pid"));
    }

    @Override
    public void setPid(String value) {
        realm.checkIfValid();
        row.setString(Realm.columnIndices.get("RealmAction").get("pid"), (String) value);
    }

    @Override
    public boolean getKeepForever() {
        realm.checkIfValid();
        return (boolean) row.getBoolean(Realm.columnIndices.get("RealmAction").get("keepForever"));
    }

    @Override
    public void setKeepForever(boolean value) {
        realm.checkIfValid();
        row.setBoolean(Realm.columnIndices.get("RealmAction").get("keepForever"), (boolean) value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if(!transaction.hasTable("class_RealmAction")) {
            Table table = transaction.getTable("class_RealmAction");
            table.addColumn(ColumnType.STRING, "actionId");
            table.addColumn(ColumnType.INTEGER, "timeOfPresentation");
            table.addColumn(ColumnType.INTEGER, "sentToServerTimestamp");
            table.addColumn(ColumnType.INTEGER, "createdAt");
            table.addColumn(ColumnType.INTEGER, "trigger");
            table.addColumn(ColumnType.STRING, "pid");
            table.addColumn(ColumnType.BOOLEAN, "keepForever");
            table.setPrimaryKey("");
            return table;
        }
        return transaction.getTable("class_RealmAction");
    }

    public static void validateTable(ImplicitTransaction transaction) {
        if(transaction.hasTable("class_RealmAction")) {
            Table table = transaction.getTable("class_RealmAction");
            if(table.getColumnCount() != 7) {
                throw new IllegalStateException("Column count does not match");
            }
            Map<String, ColumnType> columnTypes = new HashMap<String, ColumnType>();
            for(long i = 0; i < 7; i++) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            if (!columnTypes.containsKey("actionId")) {
                throw new IllegalStateException("Missing column 'actionId'");
            }
            if (columnTypes.get("actionId") != ColumnType.STRING) {
                throw new IllegalStateException("Invalid type 'String' for column 'actionId'");
            }
            if (!columnTypes.containsKey("timeOfPresentation")) {
                throw new IllegalStateException("Missing column 'timeOfPresentation'");
            }
            if (columnTypes.get("timeOfPresentation") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'timeOfPresentation'");
            }
            if (!columnTypes.containsKey("sentToServerTimestamp")) {
                throw new IllegalStateException("Missing column 'sentToServerTimestamp'");
            }
            if (columnTypes.get("sentToServerTimestamp") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'sentToServerTimestamp'");
            }
            if (!columnTypes.containsKey("createdAt")) {
                throw new IllegalStateException("Missing column 'createdAt'");
            }
            if (columnTypes.get("createdAt") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'long' for column 'createdAt'");
            }
            if (!columnTypes.containsKey("trigger")) {
                throw new IllegalStateException("Missing column 'trigger'");
            }
            if (columnTypes.get("trigger") != ColumnType.INTEGER) {
                throw new IllegalStateException("Invalid type 'int' for column 'trigger'");
            }
            if (!columnTypes.containsKey("pid")) {
                throw new IllegalStateException("Missing column 'pid'");
            }
            if (columnTypes.get("pid") != ColumnType.STRING) {
                throw new IllegalStateException("Invalid type 'String' for column 'pid'");
            }
            if (!columnTypes.containsKey("keepForever")) {
                throw new IllegalStateException("Missing column 'keepForever'");
            }
            if (columnTypes.get("keepForever") != ColumnType.BOOLEAN) {
                throw new IllegalStateException("Invalid type 'boolean' for column 'keepForever'");
            }
        }
    }

    public static List<String> getFieldNames() {
        return Arrays.asList("actionId", "timeOfPresentation", "sentToServerTimestamp", "createdAt", "trigger", "pid", "keepForever");
    }

    public static void populateUsingJsonObject(RealmAction obj, JSONObject json)
        throws JSONException {
        boolean standalone = obj.realm == null;
        if (json.has("actionId")) {
            obj.setActionId((String) json.getString("actionId"));
        }
        if (json.has("timeOfPresentation")) {
            obj.setTimeOfPresentation((long) json.getLong("timeOfPresentation"));
        }
        if (json.has("sentToServerTimestamp")) {
            obj.setSentToServerTimestamp((long) json.getLong("sentToServerTimestamp"));
        }
        if (json.has("createdAt")) {
            obj.setCreatedAt((long) json.getLong("createdAt"));
        }
        if (json.has("trigger")) {
            obj.setTrigger((int) json.getInt("trigger"));
        }
        if (json.has("pid")) {
            obj.setPid((String) json.getString("pid"));
        }
        if (json.has("keepForever")) {
            obj.setKeepForever((boolean) json.getBoolean("keepForever"));
        }
    }

    public static void populateUsingJsonStream(RealmAction obj, JsonReader reader)
        throws IOException {
        boolean standalone = obj.realm == null;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("actionId") && reader.peek() != JsonToken.NULL) {
                obj.setActionId((String) reader.nextString());
            } else if (name.equals("timeOfPresentation")  && reader.peek() != JsonToken.NULL) {
                obj.setTimeOfPresentation((long) reader.nextLong());
            } else if (name.equals("sentToServerTimestamp")  && reader.peek() != JsonToken.NULL) {
                obj.setSentToServerTimestamp((long) reader.nextLong());
            } else if (name.equals("createdAt")  && reader.peek() != JsonToken.NULL) {
                obj.setCreatedAt((long) reader.nextLong());
            } else if (name.equals("trigger")  && reader.peek() != JsonToken.NULL) {
                obj.setTrigger((int) reader.nextInt());
            } else if (name.equals("pid")  && reader.peek() != JsonToken.NULL) {
                obj.setPid((String) reader.nextString());
            } else if (name.equals("keepForever")  && reader.peek() != JsonToken.NULL) {
                obj.setKeepForever((boolean) reader.nextBoolean());
            } else {
                reader.skipValue();
            }
        }
        reader.endObject();
    }

    public static RealmAction copyOrUpdate(Realm realm, RealmAction object, boolean update, Map<RealmObject,RealmObject> cache) {
        return copy(realm, object, update, cache);
    }

    public static RealmAction copy(Realm realm, RealmAction newObject, boolean update, Map<RealmObject,RealmObject> cache) {
        RealmAction realmObject = realm.createObject(RealmAction.class);
        cache.put(newObject, realmObject);
        realmObject.setActionId(newObject.getActionId() != null ? newObject.getActionId() : "");
        realmObject.setTimeOfPresentation(newObject.getTimeOfPresentation());
        realmObject.setSentToServerTimestamp(newObject.getSentToServerTimestamp());
        realmObject.setCreatedAt(newObject.getCreatedAt());
        realmObject.setTrigger(newObject.getTrigger());
        realmObject.setPid(newObject.getPid() != null ? newObject.getPid() : "");
        realmObject.setKeepForever(newObject.getKeepForever());
        return realmObject;
    }

    static RealmAction update(Realm realm, RealmAction realmObject, RealmAction newObject, Map<RealmObject, RealmObject> cache) {
        realmObject.setActionId(newObject.getActionId() != null ? newObject.getActionId() : "");
        realmObject.setTimeOfPresentation(newObject.getTimeOfPresentation());
        realmObject.setSentToServerTimestamp(newObject.getSentToServerTimestamp());
        realmObject.setCreatedAt(newObject.getCreatedAt());
        realmObject.setTrigger(newObject.getTrigger());
        realmObject.setPid(newObject.getPid() != null ? newObject.getPid() : "");
        realmObject.setKeepForever(newObject.getKeepForever());
        return realmObject;
    }

    @Override
    public String toString() {
        if (!isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("RealmAction = [");
        stringBuilder.append("{actionId:");
        stringBuilder.append(getActionId());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{timeOfPresentation:");
        stringBuilder.append(getTimeOfPresentation());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{sentToServerTimestamp:");
        stringBuilder.append(getSentToServerTimestamp());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{createdAt:");
        stringBuilder.append(getCreatedAt());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{trigger:");
        stringBuilder.append(getTrigger());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{pid:");
        stringBuilder.append(getPid());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{keepForever:");
        stringBuilder.append(getKeepForever());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        String realmName = realm.getPath();
        String tableName = row.getTable().getName();
        long rowIndex = row.getIndex();

        int result = 17;
        result = 31 * result + ((realmName != null) ? realmName.hashCode() : 0);
        result = 31 * result + ((tableName != null) ? tableName.hashCode() : 0);
        result = 31 * result + (int) (rowIndex ^ (rowIndex >>> 32));
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RealmActionRealmProxy aRealmAction = (RealmActionRealmProxy)o;

        String path = realm.getPath();
        String otherPath = aRealmAction.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) return false;;

        String tableName = row.getTable().getName();
        String otherTableName = aRealmAction.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) return false;

        if (row.getIndex() != aRealmAction.row.getIndex()) return false;

        return true;
    }

}
