/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.vectorpathoutlineprovider;

import android.annotation.TargetApi;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.PointF;
import android.view.View;
import android.view.ViewOutlineProvider;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TargetApi(value=21)
class InternalProvider
extends ViewOutlineProvider {
    private final float width;
    private final float height;
    private final PointF[] points;
    private final Path path = new Path();
    private float lastScaleX = Float.NaN;
    private float lastScaleY = Float.NaN;

    InternalProvider(String path, float width, float height) {
        this.width = width;
        this.height = height;
        Pattern pattern = Pattern.compile("[mhlvMLHV][-0-9., ]*");
        Matcher matcher = pattern.matcher(path);
        ArrayList<PointF> points = new ArrayList<PointF>();
        while (matcher.find()) {
            String command = matcher.group();
            String[] pair = command.substring(1).trim().split("[, ]");
            if (pair.length < 2) continue;
            points.add(new PointF(Float.parseFloat(pair[0].trim()), Float.parseFloat(pair[1].trim())));
        }
        this.points = points.toArray(new PointF[points.size()]);
    }

    public void getOutline(View view, Outline outline) {
        float scaleX = (float)view.getWidth() / this.width;
        float scaleY = (float)view.getHeight() / this.height;
        if (scaleX == 0.0f || scaleY == 0.0f) {
            return;
        }
        if (scaleX != this.lastScaleX || scaleY != this.lastScaleY) {
            this.lastScaleX = scaleX;
            this.lastScaleY = scaleY;
            this.path.reset();
            for (int i = 0; i < this.points.length; ++i) {
                PointF point = this.points[i];
                if (i == 0) {
                    this.path.moveTo(point.x * scaleX, point.y * scaleY);
                    continue;
                }
                this.path.lineTo(point.x * scaleX, point.y * scaleY);
            }
            this.path.close();
        }
        outline.setConvexPath(this.path);
    }
}

