/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.permissionbitte;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.sensorberg.permissionbitte.Permission;
import com.sensorberg.permissionbitte.PermissionResult;
import com.sensorberg.permissionbitte.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionBitteFragment
extends Fragment {
    private static final int BITTE_LET_ME_PERMISSION = 23;
    private final MutableLiveData<Permissions> mutableLiveData = new MutableLiveData();
    final LiveData<Permissions> permissionLiveData = this.mutableLiveData;
    private boolean askForPermission = false;
    private List<String> ignorePermissions = new ArrayList<String>();

    public PermissionBitteFragment() {
        this.setRetainInstance(true);
    }

    public void onResume() {
        super.onResume();
        if (this.askForPermission) {
            this.askForPermission = false;
            this.ask(this.ignorePermissions);
        } else {
            this.updatePermissions();
        }
    }

    void ask(List<String> ignorePermissions) {
        if (!this.isResumed()) {
            this.ignorePermissions = ignorePermissions;
            this.askForPermission = true;
            return;
        }
        Map<String, PermissionResult> allPermissions = this.getPermissions((Context)this.getActivity());
        if (allPermissions.isEmpty()) {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
            return;
        }
        Set<String> permissionNames = allPermissions.keySet();
        for (String ignoredPermission : ignorePermissions) {
            permissionNames.remove(ignoredPermission);
        }
        if (!permissionNames.isEmpty()) {
            this.requestPermissions(permissionNames.toArray(new String[0]), 23);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != 23 || permissions.length <= 0) {
            return;
        }
        HashMap<String, PermissionResult> permissionMap = new HashMap<String, PermissionResult>();
        for (int i = 0; i < permissions.length; ++i) {
            String name = permissions[i];
            if (grantResults[i] == -1) {
                if (this.shouldShowRequestPermissionRationale(name)) {
                    permissionMap.put(name, PermissionResult.SHOW_RATIONALE);
                    continue;
                }
                permissionMap.put(name, PermissionResult.DENIED);
                continue;
            }
            permissionMap.put(name, PermissionResult.GRANTED);
        }
        this.setPermissions(new Permissions(permissionMap), true);
    }

    @TargetApi(value=16)
    @NonNull
    private Map<String, PermissionResult> getPermissions(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packageInfo = null;
        try {
            packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        HashMap<String, PermissionResult> permissions = new HashMap<String, PermissionResult>();
        if (packageInfo == null || packageInfo.requestedPermissions == null || packageInfo.requestedPermissionsFlags == null) {
            return permissions;
        }
        for (int i = 0; i < packageInfo.requestedPermissions.length; ++i) {
            int flags = packageInfo.requestedPermissionsFlags[i];
            String group = null;
            try {
                group = packageManager.getPermissionInfo((String)packageInfo.requestedPermissions[i], (int)0).group;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            String name = packageInfo.requestedPermissions[i];
            if (group == null) continue;
            if ((flags & 2) == 0) {
                if (this.shouldShowRequestPermissionRationale(name)) {
                    permissions.put(name, PermissionResult.SHOW_RATIONALE);
                    continue;
                }
                permissions.put(name, PermissionResult.REQUEST_PERMISSION);
                continue;
            }
            permissions.put(name, PermissionResult.GRANTED);
        }
        return permissions;
    }

    private void updatePermissions() {
        Map<String, PermissionResult> permissionMap = this.getPermissions((Context)this.getActivity());
        Permissions lastKnownPermissions = (Permissions)this.mutableLiveData.getValue();
        if (lastKnownPermissions != null) {
            Set<Permission> deniedPermissions = lastKnownPermissions.filter(PermissionResult.DENIED);
            for (Permission deniedPermission : deniedPermissions) {
                String deniedPermissionName = deniedPermission.getName();
                PermissionResult permissionResult = permissionMap.get(deniedPermissionName);
                if (permissionResult == null || permissionResult == PermissionResult.GRANTED) continue;
                permissionMap.put(deniedPermissionName, PermissionResult.DENIED);
            }
        }
        this.setPermissions(new Permissions(permissionMap), false);
    }

    private void setPermissions(Permissions permissions, boolean forceUpdate) {
        if (forceUpdate) {
            this.mutableLiveData.setValue((Object)permissions);
        } else if (!permissions.equals(this.mutableLiveData.getValue())) {
            this.mutableLiveData.setValue((Object)permissions);
        }
    }
}

