/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.permissionbitte;

import android.content.Intent;
import android.net.Uri;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LiveData;
import com.sensorberg.permissionbitte.PermissionBitteFragment;
import com.sensorberg.permissionbitte.Permissions;
import java.util.ArrayList;
import java.util.List;

public class PermissionBitte {
    private static final String TAG = "PERMISSION_BITTE";

    public static LiveData<Permissions> permissions(FragmentActivity activity) {
        return PermissionBitte.getOrCreate((FragmentActivity)activity).permissionLiveData;
    }

    public static void ask(FragmentActivity activity) {
        PermissionBitte.getOrCreate(activity).ask(new ArrayList<String>());
    }

    public static void ask(FragmentActivity activity, List<String> ignoredPermissions) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(ignoredPermissions);
        PermissionBitte.getOrCreate(activity).ask(arrayList);
    }

    public static void goToSettings(FragmentActivity activity) {
        activity.startActivity(new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)activity.getPackageName(), null)));
    }

    private static PermissionBitteFragment getOrCreate(FragmentActivity activity) {
        return PermissionBitte.getOrCreate(activity, new ArrayList<String>());
    }

    private static PermissionBitteFragment getOrCreate(FragmentActivity activity, ArrayList<String> ignorePermissions) {
        PermissionBitteFragment permissionBitteFragment = (PermissionBitteFragment)activity.getSupportFragmentManager().findFragmentByTag(TAG);
        if (permissionBitteFragment == null) {
            permissionBitteFragment = new PermissionBitteFragment();
            activity.getSupportFragmentManager().beginTransaction().add((Fragment)permissionBitteFragment, TAG).commitAllowingStateLoss();
        }
        return permissionBitteFragment;
    }
}

