/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.permissionbitte;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.sensorberg.permissionbitte.PermissionResult;
import java.util.Arrays;

public class Permission
implements Parcelable {
    @NonNull
    private final String name;
    @NonNull
    private final PermissionResult result;
    public static final Parcelable.Creator<Permission> CREATOR = new Parcelable.Creator<Permission>(){

        public Permission createFromParcel(Parcel source) {
            return new Permission(source);
        }

        public Permission[] newArray(int size) {
            return new Permission[size];
        }
    };

    Permission(String name, PermissionResult result) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.result = (PermissionResult)((Object)Preconditions.checkNotNull((Object)((Object)result)));
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public PermissionResult getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission that = (Permission)o;
        return this.name.equals(that.name) && this.result == that.result;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.result});
    }

    public String toString() {
        return "Permission{name='" + this.name + '\'' + ", result=" + (Object)((Object)this.result) + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeInt(this.result.ordinal());
    }

    protected Permission(Parcel in) {
        this.name = (String)Preconditions.checkNotNull((Object)in.readString());
        this.result = PermissionResult.values()[in.readInt()];
    }
}

