/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.permissionbitte;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import com.sensorberg.permissionbitte.Permission;
import com.sensorberg.permissionbitte.PermissionResult;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Permissions {
    private final Map<String, PermissionResult> map;

    Permissions(Map<String, PermissionResult> map) {
        this.map = (Map)Preconditions.checkNotNull(map);
    }

    @NonNull
    public Set<Permission> getPermissionSet() {
        HashSet<Permission> set = new HashSet<Permission>();
        for (String key : this.map.keySet()) {
            set.add(new Permission(key, this.map.get(key)));
        }
        return set;
    }

    @NonNull
    public Set<Permission> filter(PermissionResult permissionResult) {
        HashSet<Permission> set = new HashSet<Permission>();
        for (String key : this.map.keySet()) {
            PermissionResult result = this.map.get(key);
            if (result != permissionResult) continue;
            set.add(new Permission(key, this.map.get(key)));
        }
        return set;
    }

    public boolean deniedPermanently() {
        return this.hasPermissionResult(PermissionResult.DENIED);
    }

    public boolean showRationale() {
        return this.hasPermissionResult(PermissionResult.SHOW_RATIONALE);
    }

    public boolean needAskingForPermission() {
        return this.hasPermissionResult(PermissionResult.REQUEST_PERMISSION);
    }

    public boolean allGranted() {
        for (PermissionResult result : this.map.values()) {
            if (result == PermissionResult.GRANTED) continue;
            return false;
        }
        return true;
    }

    private boolean hasPermissionResult(PermissionResult permissionResult) {
        return this.map.containsValue((Object)permissionResult);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permissions that = (Permissions)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.map});
    }
}

