/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.permissionbitte;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import com.sensorberg.permissionbitte.BitteBitte;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PermissionBitteImpl
extends Fragment {
    private static final int BITTE_LET_ME_PERMISSION = 23;
    private WeakReference<BitteBitte> weakYesYouCan;

    public void setYesYouCan(@Nullable BitteBitte bitteBitte) {
        this.weakYesYouCan = bitteBitte == null ? null : new WeakReference<BitteBitte>(bitteBitte);
    }

    public PermissionBitteImpl() {
        this.setRetainInstance(true);
    }

    public void onResume() {
        super.onResume();
        String[] needed = PermissionBitteImpl.neededPermissions((Context)this.getActivity());
        if (needed.length > 0) {
            this.requestPermissions(needed, 23);
        } else {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 23 && permissions.length > 0) {
            BitteBitte bitteBitte;
            BitteBitte bitteBitte2 = bitteBitte = this.weakYesYouCan == null ? null : (BitteBitte)this.weakYesYouCan.get();
            if (bitteBitte != null) {
                boolean denied = false;
                for (int i = 0; i < permissions.length; ++i) {
                    if (grantResults[i] != -1) continue;
                    if (this.shouldShowRequestPermissionRationale(permissions[i])) {
                        bitteBitte.askNicer();
                    } else {
                        bitteBitte.noYouCant();
                    }
                    denied = true;
                }
                if (!denied) {
                    bitteBitte.yesYouCan();
                }
            }
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        }
    }

    @TargetApi(value=16)
    @NonNull
    static String[] neededPermissions(Context context) {
        PackageInfo info = null;
        try {
            info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        ArrayList<String> needed = new ArrayList<String>();
        if (info != null && info.requestedPermissions != null && info.requestedPermissionsFlags != null) {
            for (int i = 0; i < info.requestedPermissions.length; ++i) {
                int flags = info.requestedPermissionsFlags[i];
                if ((flags & 2) != 0) continue;
                needed.add(info.requestedPermissions[i]);
            }
        }
        return needed.toArray(new String[needed.size()]);
    }
}

