/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.filepreferences;

import com.sensorberg.filepreferences.FileAccess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/sensorberg/filepreferences/RealFileAccess;", "Lcom/sensorberg/filepreferences/FileAccess;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "cache", "", "loadData", "saveData", "", "data", "toString", "Companion", "preferences_release"})
public final class RealFileAccess
implements FileAccess {
    private String cache;
    private final File file;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String loadData() {
        this.cache = this.file.exists() ? RealFileAccess.Companion.getStringFromFile(this.file) : null;
        return this.cache;
    }

    @Override
    public void saveData(@NotNull String data2) {
        Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
        if (!this.file.exists() || Intrinsics.areEqual((Object)data2, (Object)this.cache) ^ true) {
            RealFileAccess.Companion.setStringToFile(this.file, data2);
            this.cache = data2;
        }
    }

    @NotNull
    public String toString() {
        return "FileAccess to " + this.file.getAbsolutePath();
    }

    public RealFileAccess(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lcom/sensorberg/filepreferences/RealFileAccess$Companion;", "", "()V", "getStringFromFile", "", "file", "Ljava/io/File;", "setStringToFile", "", "string", "preferences_release"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getStringFromFile(File file) {
            FileInputStream stream = null;
            BufferedReader reader = null;
            StringBuilder sb = new StringBuilder();
            try {
                stream = new FileInputStream(file);
                reader = new BufferedReader(new InputStreamReader(stream));
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line);
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable) {
                BufferedReader bufferedReader = reader;
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                FileInputStream fileInputStream = stream;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw throwable;
            }
            reader.close();
            stream.close();
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setStringToFile(File file, String string) {
            FileOutputStream stream = null;
            OutputStreamWriter writer = null;
            try {
                stream = new FileOutputStream(file);
                writer = new OutputStreamWriter(stream);
                writer.write(string);
            }
            catch (Throwable throwable) {
                OutputStreamWriter outputStreamWriter = writer;
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                FileOutputStream fileOutputStream = stream;
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                }
                FileOutputStream fileOutputStream2 = stream;
                if (fileOutputStream2 != null) {
                    fileOutputStream2.close();
                }
                throw throwable;
            }
            writer.close();
            stream.flush();
            stream.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

