/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.filepreferences;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FileWalkDirection;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/sensorberg/filepreferences/PreferencesMigration;", "", "()V", "deletePreferencesFileAPI24", "", "context", "Landroid/content/Context;", "name", "", "findPreferencesFile", "Ljava/io/File;", "findPreferencesFile$preferences_release", "findPreferencesFileDirectly", "findPreferencesFileDirectly$preferences_release", "findPreferencesFileRecursively", "findPreferencesFileRecursively$preferences_release", "migrate", "", "destination", "Landroid/content/SharedPreferences;", "preferences_release"})
public final class PreferencesMigration {
    public static final PreferencesMigration INSTANCE;

    public final boolean migrate(@NotNull Context context, @NotNull String name, @NotNull SharedPreferences destination) {
        File prefsFile;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        File file = prefsFile = this.findPreferencesFile$preferences_release(context, name);
        if (file == null || !file.exists()) {
            return false;
        }
        boolean anyValueMigrated = false;
        SharedPreferences oldPrefs = context.getSharedPreferences(name, 0);
        SharedPreferences.Editor editor = destination.edit();
        boolean bl = false;
        boolean bl2 = false;
        SharedPreferences.Editor $this$with = editor;
        boolean bl3 = false;
        SharedPreferences sharedPreferences = oldPrefs;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"oldPrefs");
        for (Map.Entry entry : sharedPreferences.getAll().entrySet()) {
            anyValueMigrated = true;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Timber.d((String)("Migrating " + key + " from " + name + " preferences"), (Object[])new Object[0]);
            Object v = value;
            if (v instanceof String) {
                $this$with.putString(key, (String)value);
                continue;
            }
            if (v instanceof Boolean) {
                $this$with.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (v instanceof Long) {
                $this$with.putLong(key, ((Number)value).longValue());
                continue;
            }
            if (v instanceof Float) {
                $this$with.putFloat(key, ((Number)value).floatValue());
                continue;
            }
            if (v instanceof Integer) {
                $this$with.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (TypeIntrinsics.isMutableSet(v)) {
                Object v2 = value;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
                }
                $this$with.putStringSet(key, TypeIntrinsics.asMutableSet(v2));
                continue;
            }
            if (v == null) {
                throw (Throwable)new IllegalArgumentException("Value should never be null");
            }
            throw (Throwable)new IllegalArgumentException("Unexpected type " + value.getClass().getSimpleName());
        }
        $this$with.commit();
        oldPrefs.edit().clear().commit();
        if (Build.VERSION.SDK_INT >= 24) {
            this.deletePreferencesFileAPI24(context, name);
        }
        prefsFile.delete();
        return anyValueMigrated;
    }

    @TargetApi(value=24)
    private final void deletePreferencesFileAPI24(Context context, String name) {
        context.deleteSharedPreferences(name);
    }

    @Nullable
    public final File findPreferencesFile$preferences_release(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        File file = this.findPreferencesFileDirectly$preferences_release(context, name);
        if (file == null) {
            file = this.findPreferencesFileRecursively$preferences_release(context, name);
        }
        return file;
    }

    @Nullable
    public final File findPreferencesFileDirectly$preferences_release(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        File rootDir = ContextCompat.getDataDir((Context)context);
        File folder = new File(rootDir, "shared_prefs/");
        File file = new File(folder, name + ".xml");
        return file.exists() ? file : null;
    }

    @Nullable
    public final File findPreferencesFileRecursively$preferences_release(@NotNull Context context, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        File rootDir = ContextCompat.getDataDir((Context)context);
        File file = rootDir;
        if (file != null && (file = FilesKt.walk((File)file, (FileWalkDirection)FileWalkDirection.TOP_DOWN)) != null) {
            Sequence $this$forEach$iv = (Sequence)file;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)(name + ".xml"))) continue;
                return it;
            }
        }
        return null;
    }

    private PreferencesMigration() {
    }

    static {
        PreferencesMigration preferencesMigration;
        INSTANCE = preferencesMigration = new PreferencesMigration();
    }
}

