/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.filepreferences;

import android.content.Context;
import android.content.SharedPreferences;
import com.sensorberg.executioner.Executioner;
import com.sensorberg.filepreferences.FileAccess;
import com.sensorberg.filepreferences.FilePreferences;
import com.sensorberg.filepreferences.PreferencesEditor;
import com.sensorberg.filepreferences.PreferencesMigration;
import com.sensorberg.filepreferences.RealFileAccess;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u000278B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ#\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0002\b\u001dJ\u0011\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0019H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u0019\u0012\u0002\b\u00030#H\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001cH\u0016J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010%\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010%\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010%\u001a\u00020+H\u0016J\u001c\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0019H\u0016J(\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\u00192\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\fH\u0016J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\rH\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u001c022\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\u0010\u00103\u001a\u00020\u00152\u0006\u00100\u001a\u00020\rH\u0016J\u0010\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0006H\u0002J\u0016\u00106\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u00069"}, d2={"Lcom/sensorberg/filepreferences/FilePreferences;", "Landroid/content/SharedPreferences;", "fileAccess", "Lcom/sensorberg/filepreferences/FileAccess;", "(Lcom/sensorberg/filepreferences/FileAccess;)V", "data", "Lorg/json/JSONObject;", "getData", "()Lorg/json/JSONObject;", "data$delegate", "Lkotlin/Lazy;", "listeners", "", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "writeCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getWriteCounter$preferences_release", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setWriteCounter$preferences_release", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "apply", "", "jsonObject", "changedKeys", "", "", "apply$preferences_release", "commit", "", "commit$preferences_release", "contains", "key", "edit", "Landroid/content/SharedPreferences$Editor;", "getAll", "", "getBoolean", "defValue", "getFloat", "", "getInt", "", "getLong", "", "getString", "getStringSet", "defValues", "registerOnSharedPreferenceChangeListener", "listener", "saveToFileAsync", "Ljava/util/concurrent/FutureTask;", "unregisterOnSharedPreferenceChangeListener", "updateData", "newData", "updateListeners", "Companion", "Factory", "preferences_release"})
public final class FilePreferences
implements SharedPreferences {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private AtomicInteger writeCounter;
    private final Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
    private final Lazy data$delegate;
    private final FileAccess fileAccess;
    @NotNull
    private static final Executor single;
    private static final Companion.defaultFactory.1 defaultFactory;
    private static Factory factory;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FilePreferences.class), "data", "getData()Lorg/json/JSONObject;"))};
        Companion = new Companion(null);
        single = Executioner.INSTANCE.newSingleExecutioner();
        defaultFactory = new Factory(){
            private final Map<File, SharedPreferences> instances;

            @NotNull
            public SharedPreferences create(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                SharedPreferences instance = this.instances.get(file);
                if (instance == null) {
                    instance = new FilePreferences(new RealFileAccess(file), null);
                    this.instances.put(file, instance);
                }
                return instance;
            }
            {
                Map map;
                Companion.defaultFactory.1 var2_1 = this;
                boolean bl = false;
                var2_1.instances = map = (Map)new LinkedHashMap<K, V>();
            }
        };
        factory = defaultFactory;
    }

    @Nullable
    public final AtomicInteger getWriteCounter$preferences_release() {
        return this.writeCounter;
    }

    public final void setWriteCounter$preferences_release(@Nullable AtomicInteger atomicInteger) {
        this.writeCounter = atomicInteger;
    }

    private final JSONObject getData() {
        Lazy lazy = this.data$delegate;
        FilePreferences filePreferences = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (JSONObject)lazy.getValue();
    }

    public boolean contains(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getData().has(key);
    }

    public boolean getBoolean(@NotNull String key, boolean defValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getData().optBoolean(key, defValue);
    }

    @Nullable
    public String getString(@NotNull String key, @Nullable String defValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getData().has(key) ? this.getData().optString(key) : (defValue == null ? null : this.getData().optString(key, defValue));
    }

    public int getInt(@NotNull String key, int defValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getData().optInt(key, defValue);
    }

    public long getLong(@NotNull String key, long defValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getData().optLong(key, defValue);
    }

    public float getFloat(@NotNull String key, float defValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (float)this.getData().optDouble(key, (double)defValue);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Set<String> getStringSet(@NotNull String key, @Nullable Set<String> defValues) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (this.getData().has(key)) {
            JSONArray array = this.getData().optJSONArray(key);
            int n = 0;
            Set set2 = new LinkedHashSet();
            n = 0;
            int n2 = array.length();
            while (n < n2) {
                void i;
                String string = array.getString((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"array.getString(i)");
                set2.add(string);
                ++i;
            }
            set = set2;
        } else {
            set = defValues;
        }
        return set;
    }

    @NotNull
    public Map<String, ?> getAll() {
        boolean bl = false;
        Map map = new LinkedHashMap();
        Iterator iterator = this.getData().keys();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"data.keys()");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            String it = (String)element$iv;
            boolean bl3 = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            Object object = this.getData().get(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"data.get(it)");
            map.put(string, object);
        }
        return map;
    }

    @NotNull
    public SharedPreferences.Editor edit() {
        return new PreferencesEditor(this, new JSONObject(this.getData().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Set<SharedPreferences.OnSharedPreferenceChangeListener> set = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Set<SharedPreferences.OnSharedPreferenceChangeListener> set = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.listeners.remove(listener);
        }
    }

    public final boolean commit$preferences_release(@NotNull JSONObject jsonObject, @NotNull Set<String> changedKeys) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull(changedKeys, (String)"changedKeys");
        this.updateData(jsonObject);
        FutureTask<Boolean> future = this.saveToFileAsync(jsonObject);
        this.updateListeners(changedKeys);
        Boolean bl = future.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"future.get()");
        return bl;
    }

    public final void apply$preferences_release(@NotNull JSONObject jsonObject, @NotNull Set<String> changedKeys) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull(changedKeys, (String)"changedKeys");
        this.updateData(jsonObject);
        this.saveToFileAsync(jsonObject);
        this.updateListeners(changedKeys);
    }

    private final FutureTask<Boolean> saveToFileAsync(JSONObject jsonObject) {
        FutureTask<Boolean> task2 = new FutureTask<Boolean>(new Callable<V>(this, jsonObject){
            final /* synthetic */ FilePreferences this$0;
            final /* synthetic */ JSONObject $jsonObject;

            public final boolean call() {
                boolean bl;
                try {
                    String string = this.$jsonObject.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject.toString()");
                    String stringData = string;
                    FilePreferences.access$getFileAccess$p(this.this$0).saveData(stringData);
                    AtomicInteger atomicInteger = this.this$0.getWriteCounter$preferences_release();
                    if (atomicInteger != null) {
                        atomicInteger.decrementAndGet();
                    }
                    bl = true;
                }
                catch (Exception e) {
                    Timber.e((Throwable)e, (String)("Failed to write shared preferences on " + FilePreferences.access$getFileAccess$p(this.this$0)), (Object[])new Object[0]);
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = filePreferences;
                this.$jsonObject = jSONObject;
            }
        });
        AtomicInteger atomicInteger = this.writeCounter;
        if (atomicInteger != null) {
            atomicInteger.incrementAndGet();
        }
        Executioner.INSTANCE.runOn(single, (Runnable)task2);
        return task2;
    }

    private final void updateListeners(Set<String> changedKeys) {
        Executioner.INSTANCE.runOn(Executioner.INSTANCE.getUI(), (Function0)new Function0<Unit>(this, changedKeys){
            final /* synthetic */ FilePreferences this$0;
            final /* synthetic */ Set $changedKeys;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Set set = FilePreferences.access$getListeners$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (set) {
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = FilePreferences.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        SharedPreferences.OnSharedPreferenceChangeListener listener = (SharedPreferences.OnSharedPreferenceChangeListener)element$iv;
                        boolean bl4 = false;
                        Iterable $this$forEach$iv2 = this.$changedKeys;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv2 : $this$forEach$iv2) {
                            String key = (String)element$iv2;
                            boolean bl5 = false;
                            listener.onSharedPreferenceChanged((SharedPreferences)this.this$0, key);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = filePreferences;
                this.$changedKeys = set;
                super(0);
            }
        });
    }

    private final void updateData(JSONObject newData) {
        String it;
        Object element$iv;
        boolean bl = false;
        Set toBeRemoved = new LinkedHashSet();
        Iterator iterator = this.getData().keys();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"data.keys()");
        Object $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            it = (String)element$iv;
            boolean bl3 = false;
            if (newData.has(it)) continue;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            toBeRemoved.add(string);
        }
        Iterator iterator4 = newData.keys();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator4, (String)"newData.keys()");
        $this$forEach$iv = iterator4;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv;
        bl2 = false;
        iterator3 = iterator2;
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            it = (String)element$iv;
            boolean bl4 = false;
            this.getData().put(it, newData.get(it));
        }
        $this$forEach$iv = toBeRemoved;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv2 = iterator2.next();
            String it2 = (String)element$iv2;
            boolean bl5 = false;
            this.getData().remove(it2);
        }
    }

    private FilePreferences(FileAccess fileAccess) {
        Set set;
        this.fileAccess = fileAccess;
        FilePreferences filePreferences = this;
        boolean bl = false;
        filePreferences.listeners = set = (Set)new LinkedHashSet();
        this.data$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JSONObject>(this){
            final /* synthetic */ FilePreferences this$0;

            @NotNull
            public final JSONObject invoke() {
                String data2 = FilePreferences.access$getFileAccess$p(this.this$0).loadData();
                return data2 != null ? new JSONObject(data2) : new JSONObject();
            }
            {
                this.this$0 = filePreferences;
                super(0);
            }
        }));
        Executioner.INSTANCE.runOn(Executioner.INSTANCE.getPOOL(), (Function0)new Function0<Unit>(){

            public final void invoke() {
                Timber.d((String)("Loading " + this.getData().hashCode() + " from " + fileAccess), (Object[])new Object[0]);
            }
        });
    }

    public static final /* synthetic */ Set access$getListeners$p(FilePreferences $this) {
        return $this.listeners;
    }

    public /* synthetic */ FilePreferences(FileAccess fileAccess, DefaultConstructorMarker $constructor_marker) {
        this(fileAccess);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/sensorberg/filepreferences/FilePreferences$Factory;", "", "create", "Landroid/content/SharedPreferences;", "file", "Ljava/io/File;", "preferences_release"})
    public static interface Factory {
        @NotNull
        public SharedPreferences create(@NotNull File var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/sensorberg/filepreferences/FilePreferences$Companion;", "", "()V", "defaultFactory", "com/sensorberg/filepreferences/FilePreferences$Companion$defaultFactory$1", "Lcom/sensorberg/filepreferences/FilePreferences$Companion$defaultFactory$1;", "factory", "Lcom/sensorberg/filepreferences/FilePreferences$Factory;", "single", "Ljava/util/concurrent/Executor;", "getSingle$preferences_release", "()Ljava/util/concurrent/Executor;", "create", "Landroid/content/SharedPreferences;", "file", "Ljava/io/File;", "filePath", "", "migrate", "", "context", "Landroid/content/Context;", "name", "destination", "setFactory", "", "preferences_release"})
    public static final class Companion {
        @NotNull
        public final Executor getSingle$preferences_release() {
            return single;
        }

        public final void setFactory(@Nullable Factory factory) {
            if (factory == null) {
                FilePreferences.factory = defaultFactory;
            } else {
                FilePreferences.factory = factory;
            }
        }

        @NotNull
        public final SharedPreferences create(@NotNull String filePath) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            return this.create(new File(filePath));
        }

        @NotNull
        public final SharedPreferences create(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return factory.create(file);
        }

        public final boolean migrate(@NotNull Context context, @NotNull String name, @NotNull SharedPreferences destination) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            return PreferencesMigration.INSTANCE.migrate(context, name, destination);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

