/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Task reminder date/time for a task")
public class TaskReminder {
    @SerializedName(value="value")
    private Integer value = null;
    @SerializedName(value="unit")
    private UnitEnum unit = null;
    @SerializedName(value="types")
    private List<String> types = new ArrayList<String>();

    public TaskReminder value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="10", required=true, value="Value of time unit before reminder is to be sent")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public TaskReminder unit(UnitEnum unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(required=true, value="Unit of time before reminder is to be sent")
    public UnitEnum getUnit() {
        return this.unit;
    }

    public void setUnit(UnitEnum unit) {
        this.unit = unit;
    }

    public TaskReminder types(List<String> types) {
        this.types = types;
        return this;
    }

    public TaskReminder addTypesItem(String typesItem) {
        this.types.add(typesItem);
        return this;
    }

    @ApiModelProperty(example="[\"email\"]", required=true, value="Type of task reminder e.g email, push")
    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskReminder taskReminder = (TaskReminder)o;
        return ObjectUtils.equals((Object)this.value, (Object)taskReminder.value) && ObjectUtils.equals((Object)((Object)this.unit), (Object)((Object)taskReminder.unit)) && ObjectUtils.equals(this.types, taskReminder.types);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.value, this.unit, this.types});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskReminder {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString((Object)this.unit)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnitEnum {
        MINUTES("minutes"),
        HOURS("hours"),
        WEEKS("weeks"),
        DAYS("days");

        private String value;

        private UnitEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnitEnum fromValue(String text) {
            for (UnitEnum b : UnitEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnitEnum> {
            public void write(JsonWriter jsonWriter, UnitEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UnitEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnitEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

