/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class GetWebhook {
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="id")
    private Long id = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="events")
    private List<String> events = new ArrayList<String>();
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="createdAt")
    private String createdAt = null;
    @SerializedName(value="modifiedAt")
    private String modifiedAt = null;

    public GetWebhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", required=true, value="URL of the webhook")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public GetWebhook id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="654", required=true, value="ID of the webhook")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public GetWebhook description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Webhook triggered on campaign openings", required=true, value="Description of the webhook")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GetWebhook events(List<String> events) {
        this.events = events;
        return this;
    }

    public GetWebhook addEventsItem(String eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public GetWebhook type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="marketing", required=true, value="Type of webhook (marketing or transactional)")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public GetWebhook createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2016-12-01T12:50:00Z", required=true, value="Creation UTC date-time of the webhook (YYYY-MM-DDTHH:mm:ss.SSSZ)")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public GetWebhook modifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-12T13:15:00Z", required=true, value="Last modification UTC date-time of the webhook (YYYY-MM-DDTHH:mm:ss.SSSZ)")
    public String getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetWebhook getWebhook = (GetWebhook)o;
        return ObjectUtils.equals((Object)this.url, (Object)getWebhook.url) && ObjectUtils.equals((Object)this.id, (Object)getWebhook.id) && ObjectUtils.equals((Object)this.description, (Object)getWebhook.description) && ObjectUtils.equals(this.events, getWebhook.events) && ObjectUtils.equals((Object)((Object)this.type), (Object)((Object)getWebhook.type)) && ObjectUtils.equals((Object)this.createdAt, (Object)getWebhook.createdAt) && ObjectUtils.equals((Object)this.modifiedAt, (Object)getWebhook.modifiedAt);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.url, this.id, this.description, this.events, this.type, this.createdAt, this.modifiedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetWebhook {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        MARKETING("marketing"),
        TRANSACTIONAL("transactional");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

