/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.ObjectUtils;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="File data that is uploaded")
public class FileData {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="authorId")
    private String authorId = null;
    @SerializedName(value="contactId")
    private Long contactId = null;
    @SerializedName(value="dealId")
    private String dealId = null;
    @SerializedName(value="companyId")
    private String companyId = null;
    @SerializedName(value="size")
    private Long size = null;
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;

    public FileData name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="example.png", value="Name of uploaded file")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileData authorId(String authorId) {
        this.authorId = authorId;
        return this;
    }

    @ApiModelProperty(example="61a5ce58y5d4795761045991", value="Account id of user which created the file")
    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public FileData contactId(Long contactId) {
        this.contactId = contactId;
        return this;
    }

    @ApiModelProperty(example="1", value="Contact id of contact on which file is uploaded")
    public Long getContactId() {
        return this.contactId;
    }

    public void setContactId(Long contactId) {
        this.contactId = contactId;
    }

    public FileData dealId(String dealId) {
        this.dealId = dealId;
        return this;
    }

    @ApiModelProperty(example="61a5ce58c5d4795761045991", value="Deal id linked to a file")
    public String getDealId() {
        return this.dealId;
    }

    public void setDealId(String dealId) {
        this.dealId = dealId;
    }

    public FileData companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(example="61a5ce58c5d4795761045991", value="Company id linked to a file")
    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public FileData size(Long size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="10", value="Size of file in bytes")
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public FileData createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2017-05-01T17:05:03.000Z", value="File created date/time")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileData fileData = (FileData)o;
        return ObjectUtils.equals((Object)this.name, (Object)fileData.name) && ObjectUtils.equals((Object)this.authorId, (Object)fileData.authorId) && ObjectUtils.equals((Object)this.contactId, (Object)fileData.contactId) && ObjectUtils.equals((Object)this.dealId, (Object)fileData.dealId) && ObjectUtils.equals((Object)this.companyId, (Object)fileData.companyId) && ObjectUtils.equals((Object)this.size, (Object)fileData.size) && ObjectUtils.equals((Object)this.createdAt, (Object)fileData.createdAt);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.name, this.authorId, this.contactId, this.dealId, this.companyId, this.size, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FileData {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    authorId: ").append(this.toIndentedString(this.authorId)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    dealId: ").append(this.toIndentedString(this.dealId)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

