/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class CreateUpdateProduct {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="imageUrl")
    private String imageUrl = null;
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="price")
    private Float price = null;
    @SerializedName(value="categories")
    private List<String> categories = null;
    @SerializedName(value="parentId")
    private String parentId = null;
    @SerializedName(value="metaInfo")
    private Map<String, Object> metaInfo = null;
    @SerializedName(value="updateEnabled")
    private Boolean updateEnabled = false;

    public CreateUpdateProduct id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="P11", required=true, value="Product ID for which you requested the details")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CreateUpdateProduct name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Iphone 11", required=true, value="Mandatory in case of creation**. Name of the product for which you requested the details")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateUpdateProduct url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://mydomain.com/product/electronics/product1", value="URL to the product")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CreateUpdateProduct imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(example="http://mydomain.com/product-absoulte-url/img.jpeg", value="Absolute URL to the cover image of the product")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public CreateUpdateProduct sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(value="Product identifier from the shop")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public CreateUpdateProduct price(Float price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(value="Price of the product")
    public Float getPrice() {
        return this.price;
    }

    public void setPrice(Float price) {
        this.price = price;
    }

    public CreateUpdateProduct categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public CreateUpdateProduct addCategoriesItem(String categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @ApiModelProperty(value="Category ID-s of the product")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public CreateUpdateProduct parentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(value="Parent product id of the product")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public CreateUpdateProduct metaInfo(Map<String, Object> metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    public CreateUpdateProduct putMetaInfoItem(String key, Object metaInfoItem) {
        if (this.metaInfo == null) {
            this.metaInfo = new HashMap<String, Object>();
        }
        this.metaInfo.put(key, metaInfoItem);
        return this;
    }

    @ApiModelProperty(example="{\"description\":\"Shoes for sports\",\"brand\":\"addidas\"}", value="Meta data of product such as description, vendor, producer, stock level. The size of cumulative metaInfo shall not exceed **1000 KB**. Maximum length of metaInfo object can be 10.")
    public Map<String, Object> getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(Map<String, Object> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public CreateUpdateProduct updateEnabled(Boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
        return this;
    }

    @ApiModelProperty(example="false", value="Facilitate to update the existing category in the same request (updateEnabled = true)")
    public Boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public void setUpdateEnabled(Boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUpdateProduct createUpdateProduct = (CreateUpdateProduct)o;
        return ObjectUtils.equals((Object)this.id, (Object)createUpdateProduct.id) && ObjectUtils.equals((Object)this.name, (Object)createUpdateProduct.name) && ObjectUtils.equals((Object)this.url, (Object)createUpdateProduct.url) && ObjectUtils.equals((Object)this.imageUrl, (Object)createUpdateProduct.imageUrl) && ObjectUtils.equals((Object)this.sku, (Object)createUpdateProduct.sku) && ObjectUtils.equals((Object)this.price, (Object)createUpdateProduct.price) && ObjectUtils.equals(this.categories, createUpdateProduct.categories) && ObjectUtils.equals((Object)this.parentId, (Object)createUpdateProduct.parentId) && ObjectUtils.equals(this.metaInfo, createUpdateProduct.metaInfo) && ObjectUtils.equals((Object)this.updateEnabled, (Object)createUpdateProduct.updateEnabled);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.name, this.url, this.imageUrl, this.sku, this.price, this.categories, this.parentId, this.metaInfo, this.updateEnabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUpdateProduct {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    metaInfo: ").append(this.toIndentedString(this.metaInfo)).append("\n");
        sb.append("    updateEnabled: ").append(this.toIndentedString(this.updateEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

