/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

@ApiModel(description="Company Details")
public class Company {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="attributes")
    private Object attributes = null;
    @SerializedName(value="linkedContactsIds")
    private List<Integer> linkedContactsIds = null;
    @SerializedName(value="linkedDealsIds")
    private List<String> linkedDealsIds = null;

    public Company id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="629475917295261d9b1f4403", value="Unique company id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Company attributes(Object attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="{\"created_at\":\"2022-01-13T19:04:24.376+05:30\",\"domain\":\"xyz\",\"last_updated_at\":\"2022-04-01T18:47:48.283+05:30\",\"name\":\"text\",\"number_of_contacts\":0,\"owner\":\"62260474111b1101704a9d85\",\"owner_assign_date\":\"2022-04-01T18:21:13.379+05:30\",\"phone_number\":8171844192,\"revenue\":10}", value="Company attributes with values")
    public Object getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Object attributes) {
        this.attributes = attributes;
    }

    public Company linkedContactsIds(List<Integer> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
        return this;
    }

    public Company addLinkedContactsIdsItem(Integer linkedContactsIdsItem) {
        if (this.linkedContactsIds == null) {
            this.linkedContactsIds = new ArrayList<Integer>();
        }
        this.linkedContactsIds.add(linkedContactsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[1,2,3]", value="Contact ids for contacts linked to this company")
    public List<Integer> getLinkedContactsIds() {
        return this.linkedContactsIds;
    }

    public void setLinkedContactsIds(List<Integer> linkedContactsIds) {
        this.linkedContactsIds = linkedContactsIds;
    }

    public Company linkedDealsIds(List<String> linkedDealsIds) {
        this.linkedDealsIds = linkedDealsIds;
        return this;
    }

    public Company addLinkedDealsIdsItem(String linkedDealsIdsItem) {
        if (this.linkedDealsIds == null) {
            this.linkedDealsIds = new ArrayList<String>();
        }
        this.linkedDealsIds.add(linkedDealsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Deals ids for companies linked to this company")
    public List<String> getLinkedDealsIds() {
        return this.linkedDealsIds;
    }

    public void setLinkedDealsIds(List<String> linkedDealsIds) {
        this.linkedDealsIds = linkedDealsIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        return ObjectUtils.equals((Object)this.id, (Object)company.id) && ObjectUtils.equals((Object)this.attributes, (Object)company.attributes) && ObjectUtils.equals(this.linkedContactsIds, company.linkedContactsIds) && ObjectUtils.equals(this.linkedDealsIds, company.linkedDealsIds);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.id, this.attributes, this.linkedContactsIds, this.linkedDealsIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Company {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    linkedContactsIds: ").append(this.toIndentedString(this.linkedContactsIds)).append("\n");
        sb.append("    linkedDealsIds: ").append(this.toIndentedString(this.linkedDealsIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

