/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.AddChildDomain;
import sibModel.AddCredits;
import sibModel.CreateChild;
import sibModel.CreateReseller;
import sibModel.GetChildAccountCreationStatus;
import sibModel.GetChildDomains;
import sibModel.GetChildInfo;
import sibModel.GetChildrenList;
import sibModel.GetSsoToken;
import sibModel.ManageIp;
import sibModel.RemainingCreditModel;
import sibModel.RemoveCredits;
import sibModel.UpdateChild;
import sibModel.UpdateChildAccountStatus;
import sibModel.UpdateChildDomain;

public class ResellerApi {
    private ApiClient apiClient;

    public ResellerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ResellerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call addCreditsCall(String childIdentifier, AddCredits addCredits, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddCredits localVarPostBody = addCredits;
        String localVarPath = "/reseller/children/{childIdentifier}/credits/add".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call addCreditsValidateBeforeCall(String childIdentifier, AddCredits addCredits, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling addCredits(Async)");
        }
        if (addCredits == null) {
            throw new ApiException("Missing the required parameter 'addCredits' when calling addCredits(Async)");
        }
        Call call = this.addCreditsCall(childIdentifier, addCredits, progressListener, progressRequestListener);
        return call;
    }

    public RemainingCreditModel addCredits(String childIdentifier, AddCredits addCredits) throws ApiException {
        ApiResponse<RemainingCreditModel> resp = this.addCreditsWithHttpInfo(childIdentifier, addCredits);
        return resp.getData();
    }

    public ApiResponse<RemainingCreditModel> addCreditsWithHttpInfo(String childIdentifier, AddCredits addCredits) throws ApiException {
        Call call = this.addCreditsValidateBeforeCall(childIdentifier, addCredits, null, null);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call addCreditsAsync(String childIdentifier, AddCredits addCredits, final ApiCallback<RemainingCreditModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.addCreditsValidateBeforeCall(childIdentifier, addCredits, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call associateIpToChildCall(String childIdentifier, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManageIp localVarPostBody = ip;
        String localVarPath = "/reseller/children/{childIdentifier}/ips/associate".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call associateIpToChildValidateBeforeCall(String childIdentifier, ManageIp ip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling associateIpToChild(Async)");
        }
        if (ip == null) {
            throw new ApiException("Missing the required parameter 'ip' when calling associateIpToChild(Async)");
        }
        Call call = this.associateIpToChildCall(childIdentifier, ip, progressListener, progressRequestListener);
        return call;
    }

    public void associateIpToChild(String childIdentifier, ManageIp ip) throws ApiException {
        this.associateIpToChildWithHttpInfo(childIdentifier, ip);
    }

    public ApiResponse<Void> associateIpToChildWithHttpInfo(String childIdentifier, ManageIp ip) throws ApiException {
        Call call = this.associateIpToChildValidateBeforeCall(childIdentifier, ip, null, null);
        return this.apiClient.execute(call);
    }

    public Call associateIpToChildAsync(String childIdentifier, ManageIp ip, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.associateIpToChildValidateBeforeCall(childIdentifier, ip, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createChildDomainCall(String childIdentifier, AddChildDomain addChildDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        AddChildDomain localVarPostBody = addChildDomain;
        String localVarPath = "/reseller/children/{childIdentifier}/domains".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createChildDomainValidateBeforeCall(String childIdentifier, AddChildDomain addChildDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling createChildDomain(Async)");
        }
        if (addChildDomain == null) {
            throw new ApiException("Missing the required parameter 'addChildDomain' when calling createChildDomain(Async)");
        }
        Call call = this.createChildDomainCall(childIdentifier, addChildDomain, progressListener, progressRequestListener);
        return call;
    }

    public void createChildDomain(String childIdentifier, AddChildDomain addChildDomain) throws ApiException {
        this.createChildDomainWithHttpInfo(childIdentifier, addChildDomain);
    }

    public ApiResponse<Void> createChildDomainWithHttpInfo(String childIdentifier, AddChildDomain addChildDomain) throws ApiException {
        Call call = this.createChildDomainValidateBeforeCall(childIdentifier, addChildDomain, null, null);
        return this.apiClient.execute(call);
    }

    public Call createChildDomainAsync(String childIdentifier, AddChildDomain addChildDomain, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createChildDomainValidateBeforeCall(childIdentifier, addChildDomain, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call createResellerChildCall(CreateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreateChild localVarPostBody = resellerChild;
        String localVarPath = "/reseller/children";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createResellerChildValidateBeforeCall(CreateChild resellerChild, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createResellerChildCall(resellerChild, progressListener, progressRequestListener);
        return call;
    }

    public CreateReseller createResellerChild(CreateChild resellerChild) throws ApiException {
        ApiResponse<CreateReseller> resp = this.createResellerChildWithHttpInfo(resellerChild);
        return resp.getData();
    }

    public ApiResponse<CreateReseller> createResellerChildWithHttpInfo(CreateChild resellerChild) throws ApiException {
        Call call = this.createResellerChildValidateBeforeCall(resellerChild, null, null);
        Type localVarReturnType = new TypeToken<CreateReseller>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createResellerChildAsync(CreateChild resellerChild, final ApiCallback<CreateReseller> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createResellerChildValidateBeforeCall(resellerChild, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateReseller>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteChildDomainCall(String childIdentifier, String domainName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childIdentifier}/domains/{domainName}".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString())).replaceAll("\\{domainName\\}", this.apiClient.escapeString(domainName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteChildDomainValidateBeforeCall(String childIdentifier, String domainName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling deleteChildDomain(Async)");
        }
        if (domainName == null) {
            throw new ApiException("Missing the required parameter 'domainName' when calling deleteChildDomain(Async)");
        }
        Call call = this.deleteChildDomainCall(childIdentifier, domainName, progressListener, progressRequestListener);
        return call;
    }

    public void deleteChildDomain(String childIdentifier, String domainName) throws ApiException {
        this.deleteChildDomainWithHttpInfo(childIdentifier, domainName);
    }

    public ApiResponse<Void> deleteChildDomainWithHttpInfo(String childIdentifier, String domainName) throws ApiException {
        Call call = this.deleteChildDomainValidateBeforeCall(childIdentifier, domainName, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteChildDomainAsync(String childIdentifier, String domainName, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteChildDomainValidateBeforeCall(childIdentifier, domainName, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteResellerChildCall(String childIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childIdentifier}".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteResellerChildValidateBeforeCall(String childIdentifier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling deleteResellerChild(Async)");
        }
        Call call = this.deleteResellerChildCall(childIdentifier, progressListener, progressRequestListener);
        return call;
    }

    public void deleteResellerChild(String childIdentifier) throws ApiException {
        this.deleteResellerChildWithHttpInfo(childIdentifier);
    }

    public ApiResponse<Void> deleteResellerChildWithHttpInfo(String childIdentifier) throws ApiException {
        Call call = this.deleteResellerChildValidateBeforeCall(childIdentifier, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteResellerChildAsync(String childIdentifier, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteResellerChildValidateBeforeCall(childIdentifier, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call dissociateIpFromChildCall(String childIdentifier, ManageIp ip, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ManageIp localVarPostBody = ip;
        String localVarPath = "/reseller/children/{childIdentifier}/ips/dissociate".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call dissociateIpFromChildValidateBeforeCall(String childIdentifier, ManageIp ip, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling dissociateIpFromChild(Async)");
        }
        if (ip == null) {
            throw new ApiException("Missing the required parameter 'ip' when calling dissociateIpFromChild(Async)");
        }
        Call call = this.dissociateIpFromChildCall(childIdentifier, ip, progressListener, progressRequestListener);
        return call;
    }

    public void dissociateIpFromChild(String childIdentifier, ManageIp ip) throws ApiException {
        this.dissociateIpFromChildWithHttpInfo(childIdentifier, ip);
    }

    public ApiResponse<Void> dissociateIpFromChildWithHttpInfo(String childIdentifier, ManageIp ip) throws ApiException {
        Call call = this.dissociateIpFromChildValidateBeforeCall(childIdentifier, ip, null, null);
        return this.apiClient.execute(call);
    }

    public Call dissociateIpFromChildAsync(String childIdentifier, ManageIp ip, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.dissociateIpFromChildValidateBeforeCall(childIdentifier, ip, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getChildAccountCreationStatusCall(String childIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childIdentifier}/accountCreationStatus".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChildAccountCreationStatusValidateBeforeCall(String childIdentifier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling getChildAccountCreationStatus(Async)");
        }
        Call call = this.getChildAccountCreationStatusCall(childIdentifier, progressListener, progressRequestListener);
        return call;
    }

    public GetChildAccountCreationStatus getChildAccountCreationStatus(String childIdentifier) throws ApiException {
        ApiResponse<GetChildAccountCreationStatus> resp = this.getChildAccountCreationStatusWithHttpInfo(childIdentifier);
        return resp.getData();
    }

    public ApiResponse<GetChildAccountCreationStatus> getChildAccountCreationStatusWithHttpInfo(String childIdentifier) throws ApiException {
        Call call = this.getChildAccountCreationStatusValidateBeforeCall(childIdentifier, null, null);
        Type localVarReturnType = new TypeToken<GetChildAccountCreationStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChildAccountCreationStatusAsync(String childIdentifier, final ApiCallback<GetChildAccountCreationStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChildAccountCreationStatusValidateBeforeCall(childIdentifier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildAccountCreationStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getChildDomainsCall(String childIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childIdentifier}/domains".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChildDomainsValidateBeforeCall(String childIdentifier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling getChildDomains(Async)");
        }
        Call call = this.getChildDomainsCall(childIdentifier, progressListener, progressRequestListener);
        return call;
    }

    public GetChildDomains getChildDomains(String childIdentifier) throws ApiException {
        ApiResponse<GetChildDomains> resp = this.getChildDomainsWithHttpInfo(childIdentifier);
        return resp.getData();
    }

    public ApiResponse<GetChildDomains> getChildDomainsWithHttpInfo(String childIdentifier) throws ApiException {
        Call call = this.getChildDomainsValidateBeforeCall(childIdentifier, null, null);
        Type localVarReturnType = new TypeToken<GetChildDomains>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChildDomainsAsync(String childIdentifier, final ApiCallback<GetChildDomains> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChildDomainsValidateBeforeCall(childIdentifier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildDomains>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getChildInfoCall(String childIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childIdentifier}".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getChildInfoValidateBeforeCall(String childIdentifier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling getChildInfo(Async)");
        }
        Call call = this.getChildInfoCall(childIdentifier, progressListener, progressRequestListener);
        return call;
    }

    public GetChildInfo getChildInfo(String childIdentifier) throws ApiException {
        ApiResponse<GetChildInfo> resp = this.getChildInfoWithHttpInfo(childIdentifier);
        return resp.getData();
    }

    public ApiResponse<GetChildInfo> getChildInfoWithHttpInfo(String childIdentifier) throws ApiException {
        Call call = this.getChildInfoValidateBeforeCall(childIdentifier, null, null);
        Type localVarReturnType = new TypeToken<GetChildInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getChildInfoAsync(String childIdentifier, final ApiCallback<GetChildInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getChildInfoValidateBeforeCall(childIdentifier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getResellerChildsCall(Long limit, Long offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getResellerChildsValidateBeforeCall(Long limit, Long offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getResellerChildsCall(limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public GetChildrenList getResellerChilds(Long limit, Long offset) throws ApiException {
        ApiResponse<GetChildrenList> resp = this.getResellerChildsWithHttpInfo(limit, offset);
        return resp.getData();
    }

    public ApiResponse<GetChildrenList> getResellerChildsWithHttpInfo(Long limit, Long offset) throws ApiException {
        Call call = this.getResellerChildsValidateBeforeCall(limit, offset, null, null);
        Type localVarReturnType = new TypeToken<GetChildrenList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getResellerChildsAsync(Long limit, Long offset, final ApiCallback<GetChildrenList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getResellerChildsValidateBeforeCall(limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetChildrenList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSsoTokenCall(String childIdentifier, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/reseller/children/{childIdentifier}/auth".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSsoTokenValidateBeforeCall(String childIdentifier, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling getSsoToken(Async)");
        }
        Call call = this.getSsoTokenCall(childIdentifier, progressListener, progressRequestListener);
        return call;
    }

    public GetSsoToken getSsoToken(String childIdentifier) throws ApiException {
        ApiResponse<GetSsoToken> resp = this.getSsoTokenWithHttpInfo(childIdentifier);
        return resp.getData();
    }

    public ApiResponse<GetSsoToken> getSsoTokenWithHttpInfo(String childIdentifier) throws ApiException {
        Call call = this.getSsoTokenValidateBeforeCall(childIdentifier, null, null);
        Type localVarReturnType = new TypeToken<GetSsoToken>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSsoTokenAsync(String childIdentifier, final ApiCallback<GetSsoToken> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSsoTokenValidateBeforeCall(childIdentifier, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSsoToken>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removeCreditsCall(String childIdentifier, RemoveCredits removeCredits, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        RemoveCredits localVarPostBody = removeCredits;
        String localVarPath = "/reseller/children/{childIdentifier}/credits/remove".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removeCreditsValidateBeforeCall(String childIdentifier, RemoveCredits removeCredits, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling removeCredits(Async)");
        }
        if (removeCredits == null) {
            throw new ApiException("Missing the required parameter 'removeCredits' when calling removeCredits(Async)");
        }
        Call call = this.removeCreditsCall(childIdentifier, removeCredits, progressListener, progressRequestListener);
        return call;
    }

    public RemainingCreditModel removeCredits(String childIdentifier, RemoveCredits removeCredits) throws ApiException {
        ApiResponse<RemainingCreditModel> resp = this.removeCreditsWithHttpInfo(childIdentifier, removeCredits);
        return resp.getData();
    }

    public ApiResponse<RemainingCreditModel> removeCreditsWithHttpInfo(String childIdentifier, RemoveCredits removeCredits) throws ApiException {
        Call call = this.removeCreditsValidateBeforeCall(childIdentifier, removeCredits, null, null);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removeCreditsAsync(String childIdentifier, RemoveCredits removeCredits, final ApiCallback<RemainingCreditModel> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removeCreditsValidateBeforeCall(childIdentifier, removeCredits, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemainingCreditModel>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateChildAccountStatusCall(String childIdentifier, UpdateChildAccountStatus updateChildAccountStatus, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateChildAccountStatus localVarPostBody = updateChildAccountStatus;
        String localVarPath = "/reseller/children/{childIdentifier}/accountStatus".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateChildAccountStatusValidateBeforeCall(String childIdentifier, UpdateChildAccountStatus updateChildAccountStatus, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling updateChildAccountStatus(Async)");
        }
        if (updateChildAccountStatus == null) {
            throw new ApiException("Missing the required parameter 'updateChildAccountStatus' when calling updateChildAccountStatus(Async)");
        }
        Call call = this.updateChildAccountStatusCall(childIdentifier, updateChildAccountStatus, progressListener, progressRequestListener);
        return call;
    }

    public void updateChildAccountStatus(String childIdentifier, UpdateChildAccountStatus updateChildAccountStatus) throws ApiException {
        this.updateChildAccountStatusWithHttpInfo(childIdentifier, updateChildAccountStatus);
    }

    public ApiResponse<Void> updateChildAccountStatusWithHttpInfo(String childIdentifier, UpdateChildAccountStatus updateChildAccountStatus) throws ApiException {
        Call call = this.updateChildAccountStatusValidateBeforeCall(childIdentifier, updateChildAccountStatus, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateChildAccountStatusAsync(String childIdentifier, UpdateChildAccountStatus updateChildAccountStatus, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateChildAccountStatusValidateBeforeCall(childIdentifier, updateChildAccountStatus, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateChildDomainCall(String childIdentifier, String domainName, UpdateChildDomain updateChildDomain, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateChildDomain localVarPostBody = updateChildDomain;
        String localVarPath = "/reseller/children/{childIdentifier}/domains/{domainName}".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString())).replaceAll("\\{domainName\\}", this.apiClient.escapeString(domainName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateChildDomainValidateBeforeCall(String childIdentifier, String domainName, UpdateChildDomain updateChildDomain, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling updateChildDomain(Async)");
        }
        if (domainName == null) {
            throw new ApiException("Missing the required parameter 'domainName' when calling updateChildDomain(Async)");
        }
        if (updateChildDomain == null) {
            throw new ApiException("Missing the required parameter 'updateChildDomain' when calling updateChildDomain(Async)");
        }
        Call call = this.updateChildDomainCall(childIdentifier, domainName, updateChildDomain, progressListener, progressRequestListener);
        return call;
    }

    public void updateChildDomain(String childIdentifier, String domainName, UpdateChildDomain updateChildDomain) throws ApiException {
        this.updateChildDomainWithHttpInfo(childIdentifier, domainName, updateChildDomain);
    }

    public ApiResponse<Void> updateChildDomainWithHttpInfo(String childIdentifier, String domainName, UpdateChildDomain updateChildDomain) throws ApiException {
        Call call = this.updateChildDomainValidateBeforeCall(childIdentifier, domainName, updateChildDomain, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateChildDomainAsync(String childIdentifier, String domainName, UpdateChildDomain updateChildDomain, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateChildDomainValidateBeforeCall(childIdentifier, domainName, updateChildDomain, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call updateResellerChildCall(String childIdentifier, UpdateChild resellerChild, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdateChild localVarPostBody = resellerChild;
        String localVarPath = "/reseller/children/{childIdentifier}".replaceAll("\\{childIdentifier\\}", this.apiClient.escapeString(childIdentifier.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateResellerChildValidateBeforeCall(String childIdentifier, UpdateChild resellerChild, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (childIdentifier == null) {
            throw new ApiException("Missing the required parameter 'childIdentifier' when calling updateResellerChild(Async)");
        }
        if (resellerChild == null) {
            throw new ApiException("Missing the required parameter 'resellerChild' when calling updateResellerChild(Async)");
        }
        Call call = this.updateResellerChildCall(childIdentifier, resellerChild, progressListener, progressRequestListener);
        return call;
    }

    public void updateResellerChild(String childIdentifier, UpdateChild resellerChild) throws ApiException {
        this.updateResellerChildWithHttpInfo(childIdentifier, resellerChild);
    }

    public ApiResponse<Void> updateResellerChildWithHttpInfo(String childIdentifier, UpdateChild resellerChild) throws ApiException {
        Call call = this.updateResellerChildValidateBeforeCall(childIdentifier, resellerChild, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateResellerChildAsync(String childIdentifier, UpdateChild resellerChild, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateResellerChildValidateBeforeCall(childIdentifier, resellerChild, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

