/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import sibModel.Contact;
import sibModel.TaskReminder;

@ApiModel(description="Task Details")
public class Task {
    @SerializedName(value="firstContact")
    private Contact firstContact = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="taskTypeId")
    private String taskTypeId = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="contactsIds")
    private List<Integer> contactsIds = null;
    @SerializedName(value="contacts")
    private List<Contact> contacts = null;
    @SerializedName(value="dealsIds")
    private List<String> dealsIds = null;
    @SerializedName(value="companiesIds")
    private List<String> companiesIds = null;
    @SerializedName(value="assignToId")
    private String assignToId = null;
    @SerializedName(value="date")
    private OffsetDateTime date = null;
    @SerializedName(value="duration")
    private Integer duration = null;
    @SerializedName(value="notes")
    private String notes = null;
    @SerializedName(value="done")
    private Boolean done = null;
    @SerializedName(value="reminder")
    private TaskReminder reminder = null;
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt = null;
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt = null;
    @SerializedName(value="refs")
    private Object refs = null;

    public Task firstContact(Contact firstContact) {
        this.firstContact = firstContact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getFirstContact() {
        return this.firstContact;
    }

    public void setFirstContact(Contact firstContact) {
        this.firstContact = firstContact;
    }

    public Task id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="61a5cd07ca1347c82306ad06", value="Unique task id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Task taskTypeId(String taskTypeId) {
        this.taskTypeId = taskTypeId;
        return this;
    }

    @ApiModelProperty(example="61a5cd07ca1347c82306ad09", required=true, value="Id for type of task e.g Call / Email / Meeting etc.")
    public String getTaskTypeId() {
        return this.taskTypeId;
    }

    public void setTaskTypeId(String taskTypeId) {
        this.taskTypeId = taskTypeId;
    }

    public Task name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Task: Connect with client", required=true, value="Name of task")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Task contactsIds(List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
        return this;
    }

    public Task addContactsIdsItem(Integer contactsIdsItem) {
        if (this.contactsIds == null) {
            this.contactsIds = new ArrayList<Integer>();
        }
        this.contactsIds.add(contactsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[1,2,3]", value="Contact ids for contacts linked to this task")
    public List<Integer> getContactsIds() {
        return this.contactsIds;
    }

    public void setContactsIds(List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
    }

    public Task contacts(List<Contact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public Task addContactsItem(Contact contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<Contact>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"email\":\"contact@example.com\",\"id\":247,\"emailBlacklisted\":true,\"smsBlacklisted\":true,\"createdAt\":\"2017-05-01T17:05:03.000Z\",\"modifiedAt\":\"2017-05-01T17:05:03.000Z\",\"listIds\":[1,2],\"attributes\":{\"SMS\":\"33058407250\",\"IDENTIFICATION\":\"1-3RHQ-259\",\"CIV\":\"MS\",\"LAST_NAME\":\"Brennon\",\"FIRST_NAME\":\"Meg\",\"DOB\":\"1986-05-02T00:00:00.000Z\",\"ADDRESS\":\"1 5th avenue\",\"ZIP_CODE\":\"44300\",\"CITY\":\"New-York\",\"ACTION_CODE\":\"17HH98CH\"}},{\"email\":\"33058407248@mailin-sms.com\",\"id\":245,\"emailBlacklisted\":true,\"smsBlacklisted\":false,\"createdAt\":\"2017-05-01T17:05:03.000Z\",\"modifiedAt\":\"2017-05-01T17:05:03.000Z\",\"listIds\":[1,2,3],\"attributes\":{\"SMS\":\"33058407248\",\"IDENTIFICATION\":\"1-78JS-432\",\"CIV\":\"MS\",\"LAST_NAME\":\"Press\",\"FIRST_NAME\":\"Sophia\",\"DOB\":\"1980-09-11T00:00:00.000Z\",\"ADDRESS\":\"5 Flower Street\",\"ZIP_CODE\":\"44119\",\"CITY\":\"Seattle\",\"ACTION_CODE\":\"17HU765\"}}]", value="Contact details for contacts linked to this task")
    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public Task dealsIds(List<String> dealsIds) {
        this.dealsIds = dealsIds;
        return this;
    }

    public Task addDealsIdsItem(String dealsIdsItem) {
        if (this.dealsIds == null) {
            this.dealsIds = new ArrayList<String>();
        }
        this.dealsIds.add(dealsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Deal ids for deals a task is linked to")
    public List<String> getDealsIds() {
        return this.dealsIds;
    }

    public void setDealsIds(List<String> dealsIds) {
        this.dealsIds = dealsIds;
    }

    public Task companiesIds(List<String> companiesIds) {
        this.companiesIds = companiesIds;
        return this;
    }

    public Task addCompaniesIdsItem(String companiesIdsItem) {
        if (this.companiesIds == null) {
            this.companiesIds = new ArrayList<String>();
        }
        this.companiesIds.add(companiesIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Companies ids for companies a task is linked to")
    public List<String> getCompaniesIds() {
        return this.companiesIds;
    }

    public void setCompaniesIds(List<String> companiesIds) {
        this.companiesIds = companiesIds;
    }

    public Task assignToId(String assignToId) {
        this.assignToId = assignToId;
        return this;
    }

    @ApiModelProperty(example="5faab4b7f195bb3c4c31e62a", value="User id to whom task is assigned")
    public String getAssignToId() {
        return this.assignToId;
    }

    public void setAssignToId(String assignToId) {
        this.assignToId = assignToId;
    }

    public Task date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="2021-11-01T17:44:54.668Z", required=true, value="Task date/time")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Task duration(Integer duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="900000", value="Duration of task")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Task notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="In communication with client for resolution of queries.", value="Notes added to a task")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Task done(Boolean done) {
        this.done = done;
        return this;
    }

    @ApiModelProperty(example="false", value="Task marked as done")
    public Boolean isDone() {
        return this.done;
    }

    public void setDone(Boolean done) {
        this.done = done;
    }

    public Task reminder(TaskReminder reminder) {
        this.reminder = reminder;
        return this;
    }

    @ApiModelProperty(value="Task reminder date/time for a task")
    public TaskReminder getReminder() {
        return this.reminder;
    }

    public void setReminder(TaskReminder reminder) {
        this.reminder = reminder;
    }

    public Task createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2021-11-01T17:44:54.668Z", value="Task created date/time")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Task updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(example="2021-11-01T17:44:54.668Z", value="Task update date/time")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Task refs(Object refs) {
        this.refs = refs;
        return this;
    }

    @ApiModelProperty(example="{\"dealsIds\":[{\"id\":\"61a5ce58c5d4795761045990\",\"attributes\":{\"deal_name\":\"Deal Example\",\"deal_owner\":\"5faab4b7f195bb3c4c31e62a\",\"pipeline\":\"61122683f86562145185b489\",\"deal_stage\":\"3d696d83-c75b-404d-b062-680186b8bbb\",\"stage_updated_at\":\"2017-11-22T09:23:44.213Z\",\"created_at\":\"2017-09-24T12:33:24.657Z\",\"number_of_contacts\":1,\"last_updated_date\":\"2019-11-22T09:23:44.246Z\",\"last_activity_date\":\"2017-09-30T06:44:15.765Z\",\"number_of_activities\":1,\"close_date\":\"2019-11-21T18:30:00.000Z\",\"actual_close_date\":\"2019-11-22T09:23:44.213Z\",\"total_revenue\":0},\"linkedContactsIds\":[247],\"linkedCompaniesIds\":[]}]}", value="")
    public Object getRefs() {
        return this.refs;
    }

    public void setRefs(Object refs) {
        this.refs = refs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task task = (Task)o;
        return Objects.equals(this.firstContact, task.firstContact) && Objects.equals(this.id, task.id) && Objects.equals(this.taskTypeId, task.taskTypeId) && Objects.equals(this.name, task.name) && Objects.equals(this.contactsIds, task.contactsIds) && Objects.equals(this.contacts, task.contacts) && Objects.equals(this.dealsIds, task.dealsIds) && Objects.equals(this.companiesIds, task.companiesIds) && Objects.equals(this.assignToId, task.assignToId) && Objects.equals(this.date, task.date) && Objects.equals(this.duration, task.duration) && Objects.equals(this.notes, task.notes) && Objects.equals(this.done, task.done) && Objects.equals(this.reminder, task.reminder) && Objects.equals(this.createdAt, task.createdAt) && Objects.equals(this.updatedAt, task.updatedAt) && Objects.equals(this.refs, task.refs);
    }

    public int hashCode() {
        return Objects.hash(this.firstContact, this.id, this.taskTypeId, this.name, this.contactsIds, this.contacts, this.dealsIds, this.companiesIds, this.assignToId, this.date, this.duration, this.notes, this.done, this.reminder, this.createdAt, this.updatedAt, this.refs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Task {\n");
        sb.append("    firstContact: ").append(this.toIndentedString(this.firstContact)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    taskTypeId: ").append(this.toIndentedString(this.taskTypeId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    contactsIds: ").append(this.toIndentedString(this.contactsIds)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("    dealsIds: ").append(this.toIndentedString(this.dealsIds)).append("\n");
        sb.append("    companiesIds: ").append(this.toIndentedString(this.companiesIds)).append("\n");
        sb.append("    assignToId: ").append(this.toIndentedString(this.assignToId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    done: ").append(this.toIndentedString(this.done)).append("\n");
        sb.append("    reminder: ").append(this.toIndentedString(this.reminder)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    refs: ").append(this.toIndentedString(this.refs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

