/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Note data to be saved")
public class NoteData {
    @SerializedName(value="text")
    private String text = null;
    @SerializedName(value="contactIds")
    private List<Integer> contactIds = null;
    @SerializedName(value="dealIds")
    private List<String> dealIds = null;

    public NoteData text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="In communication with client for resolution of queries.", required=true, value="Text content of a note")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public NoteData contactIds(List<Integer> contactIds) {
        this.contactIds = contactIds;
        return this;
    }

    public NoteData addContactIdsItem(Integer contactIdsItem) {
        if (this.contactIds == null) {
            this.contactIds = new ArrayList<Integer>();
        }
        this.contactIds.add(contactIdsItem);
        return this;
    }

    @ApiModelProperty(example="[247,1,2]", value="Contact Ids linked to a note")
    public List<Integer> getContactIds() {
        return this.contactIds;
    }

    public void setContactIds(List<Integer> contactIds) {
        this.contactIds = contactIds;
    }

    public NoteData dealIds(List<String> dealIds) {
        this.dealIds = dealIds;
        return this;
    }

    public NoteData addDealIdsItem(String dealIdsItem) {
        if (this.dealIds == null) {
            this.dealIds = new ArrayList<String>();
        }
        this.dealIds.add(dealIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\"]", value="Deal Ids linked to a note")
    public List<String> getDealIds() {
        return this.dealIds;
    }

    public void setDealIds(List<String> dealIds) {
        this.dealIds = dealIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoteData noteData = (NoteData)o;
        return Objects.equals(this.text, noteData.text) && Objects.equals(this.contactIds, noteData.contactIds) && Objects.equals(this.dealIds, noteData.dealIds);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.contactIds, this.dealIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NoteData {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    contactIds: ").append(this.toIndentedString(this.contactIds)).append("\n");
        sb.append("    dealIds: ").append(this.toIndentedString(this.dealIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

