/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateWebhook {
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="events")
    private List<EventsEnum> events = new ArrayList<EventsEnum>();
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.TRANSACTIONAL;
    @SerializedName(value="domain")
    private String domain = null;

    public CreateWebhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://requestb.in/173lyyx1", required=true, value="URL of the webhook")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CreateWebhook description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Webhook triggered on unsubscription", value="Description of the webhook")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateWebhook events(List<EventsEnum> events) {
        this.events = events;
        return this;
    }

    public CreateWebhook addEventsItem(EventsEnum eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="- Events triggering the webhook. Possible values for **Transactional** type webhook: #### `sent` OR `request`, `delivered`, `hardBounce`, `softBounce`, `blocked`, `spam`, `invalid`, `deferred`, `click`, `opened`, `uniqueOpened` and `unsubscribed` - Possible values for **Marketing** type webhook: #### `spam`, `opened`, `click`, `hardBounce`, `softBounce`, `unsubscribed`, `listAddition` & `delivered` - Possible values for **Inbound** type webhook: #### `inboundEmailProcessed` ")
    public List<EventsEnum> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventsEnum> events) {
        this.events = events;
    }

    public CreateWebhook type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="marketing", value="Type of the webhook")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateWebhook domain(String domain) {
        this.domain = domain;
        return this;
    }

    @ApiModelProperty(example="example.com", value="Inbound domain of webhook, required in case of event type `inbound`")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebhook createWebhook = (CreateWebhook)o;
        return Objects.equals(this.url, createWebhook.url) && Objects.equals(this.description, createWebhook.description) && Objects.equals(this.events, createWebhook.events) && Objects.equals((Object)this.type, (Object)createWebhook.type) && Objects.equals(this.domain, createWebhook.domain);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.description, this.events, this.type, this.domain});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebhook {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventsEnum {
        SENT("sent"),
        HARDBOUNCE("hardBounce"),
        SOFTBOUNCE("softBounce"),
        BLOCKED("blocked"),
        SPAM("spam"),
        DELIVERED("delivered"),
        REQUEST("request"),
        CLICK("click"),
        INVALID("invalid"),
        DEFERRED("deferred"),
        OPENED("opened"),
        UNIQUEOPENED("uniqueOpened"),
        UNSUBSCRIBED("unsubscribed"),
        LISTADDITION("listAddition"),
        CONTACTUPDATED("contactUpdated"),
        CONTACTDELETED("contactDeleted"),
        INBOUNDEMAILPROCESSED("inboundEmailProcessed");

        private String value;

        private EventsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventsEnum fromValue(String text) {
            EventsEnum[] eventsEnumArray = EventsEnum.values();
            int n = eventsEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventsEnum b = eventsEnumArray[n2];
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
                ++n2;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EventsEnum> {
            public void write(JsonWriter jsonWriter, EventsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventsEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TRANSACTIONAL("transactional"),
        MARKETING("marketing"),
        INBOUND("inbound");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            TypeEnum[] typeEnumArray = TypeEnum.values();
            int n = typeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                TypeEnum b = typeEnumArray[n2];
                if (String.valueOf(b.value).equals(text)) {
                    return b;
                }
                ++n2;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

