/*
 * Decompiled with CFR 0.152.
 */
package sibModel;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import sibModel.TaskReminder;

public class Body {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="duration")
    private Long duration = null;
    @SerializedName(value="taskTypeId")
    private String taskTypeId = null;
    @SerializedName(value="date")
    private OffsetDateTime date = null;
    @SerializedName(value="notes")
    private String notes = null;
    @SerializedName(value="done")
    private Boolean done = null;
    @SerializedName(value="assignToId")
    private String assignToId = null;
    @SerializedName(value="contactsIds")
    private List<Integer> contactsIds = null;
    @SerializedName(value="dealsIds")
    private List<String> dealsIds = null;
    @SerializedName(value="companiesIds")
    private List<String> companiesIds = null;
    @SerializedName(value="reminder")
    private TaskReminder reminder = null;

    public Body name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Task: Connect with client", required=true, value="Name of task")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Body duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="900000", value="Duration of task")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Body taskTypeId(String taskTypeId) {
        this.taskTypeId = taskTypeId;
        return this;
    }

    @ApiModelProperty(example="61a5cd07ca1347c82306ad09", required=true, value="Id for type of task e.g Call / Email / Meeting etc.")
    public String getTaskTypeId() {
        return this.taskTypeId;
    }

    public void setTaskTypeId(String taskTypeId) {
        this.taskTypeId = taskTypeId;
    }

    public Body date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="2021-11-01T17:44:54.668Z", required=true, value="Task date/time")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Body notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="In communication with client for resolution of queries.", value="Notes added to a task")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Body done(Boolean done) {
        this.done = done;
        return this;
    }

    @ApiModelProperty(example="false", value="Task marked as done")
    public Boolean isDone() {
        return this.done;
    }

    public void setDone(Boolean done) {
        this.done = done;
    }

    public Body assignToId(String assignToId) {
        this.assignToId = assignToId;
        return this;
    }

    @ApiModelProperty(example="5faab4b7f195bb3c4c31e62a", value="User id to whom task is assigned")
    public String getAssignToId() {
        return this.assignToId;
    }

    public void setAssignToId(String assignToId) {
        this.assignToId = assignToId;
    }

    public Body contactsIds(List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
        return this;
    }

    public Body addContactsIdsItem(Integer contactsIdsItem) {
        if (this.contactsIds == null) {
            this.contactsIds = new ArrayList<Integer>();
        }
        this.contactsIds.add(contactsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[1,2,3]", value="Contact ids for contacts linked to this task")
    public List<Integer> getContactsIds() {
        return this.contactsIds;
    }

    public void setContactsIds(List<Integer> contactsIds) {
        this.contactsIds = contactsIds;
    }

    public Body dealsIds(List<String> dealsIds) {
        this.dealsIds = dealsIds;
        return this;
    }

    public Body addDealsIdsItem(String dealsIdsItem) {
        if (this.dealsIds == null) {
            this.dealsIds = new ArrayList<String>();
        }
        this.dealsIds.add(dealsIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Deal ids for deals a task is linked to")
    public List<String> getDealsIds() {
        return this.dealsIds;
    }

    public void setDealsIds(List<String> dealsIds) {
        this.dealsIds = dealsIds;
    }

    public Body companiesIds(List<String> companiesIds) {
        this.companiesIds = companiesIds;
        return this;
    }

    public Body addCompaniesIdsItem(String companiesIdsItem) {
        if (this.companiesIds == null) {
            this.companiesIds = new ArrayList<String>();
        }
        this.companiesIds.add(companiesIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\",\"61a5ce58c5d4795761045992\"]", value="Companies ids for companies a task is linked to")
    public List<String> getCompaniesIds() {
        return this.companiesIds;
    }

    public void setCompaniesIds(List<String> companiesIds) {
        this.companiesIds = companiesIds;
    }

    public Body reminder(TaskReminder reminder) {
        this.reminder = reminder;
        return this;
    }

    @ApiModelProperty(value="")
    public TaskReminder getReminder() {
        return this.reminder;
    }

    public void setReminder(TaskReminder reminder) {
        this.reminder = reminder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Body body = (Body)o;
        return Objects.equals(this.name, body.name) && Objects.equals(this.duration, body.duration) && Objects.equals(this.taskTypeId, body.taskTypeId) && Objects.equals(this.date, body.date) && Objects.equals(this.notes, body.notes) && Objects.equals(this.done, body.done) && Objects.equals(this.assignToId, body.assignToId) && Objects.equals(this.contactsIds, body.contactsIds) && Objects.equals(this.dealsIds, body.dealsIds) && Objects.equals(this.companiesIds, body.companiesIds) && Objects.equals(this.reminder, body.reminder);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.duration, this.taskTypeId, this.date, this.notes, this.done, this.assignToId, this.contactsIds, this.dealsIds, this.companiesIds, this.reminder);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Body {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    taskTypeId: ").append(this.toIndentedString(this.taskTypeId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    done: ").append(this.toIndentedString(this.done)).append("\n");
        sb.append("    assignToId: ").append(this.toIndentedString(this.assignToId)).append("\n");
        sb.append("    contactsIds: ").append(this.toIndentedString(this.contactsIds)).append("\n");
        sb.append("    dealsIds: ").append(this.toIndentedString(this.dealsIds)).append("\n");
        sb.append("    companiesIds: ").append(this.toIndentedString(this.companiesIds)).append("\n");
        sb.append("    reminder: ").append(this.toIndentedString(this.reminder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

