/*
 * Decompiled with CFR 0.152.
 */
package sibApi;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import sendinblue.ApiCallback;
import sendinblue.ApiClient;
import sendinblue.ApiException;
import sendinblue.ApiResponse;
import sendinblue.Configuration;
import sendinblue.Pair;
import sendinblue.ProgressRequestBody;
import sendinblue.ProgressResponseBody;
import sibModel.GetSmsEventReport;
import sibModel.GetTransacAggregatedSmsReport;
import sibModel.GetTransacSmsReport;
import sibModel.SendSms;
import sibModel.SendTransacSms;

public class TransactionalSmsApi {
    private ApiClient apiClient;

    public TransactionalSmsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionalSmsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getSmsEventsCall(Long limit, String startDate, String endDate, Long offset, Long days, String phoneNumber, String event, String tags, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/transactionalSMS/statistics/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (days != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        }
        if (phoneNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("phoneNumber", phoneNumber));
        }
        if (event != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("event", event));
        }
        if (tags != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tags", tags));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSmsEventsValidateBeforeCall(Long limit, String startDate, String endDate, Long offset, Long days, String phoneNumber, String event, String tags, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getSmsEventsCall(limit, startDate, endDate, offset, days, phoneNumber, event, tags, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetSmsEventReport getSmsEvents(Long limit, String startDate, String endDate, Long offset, Long days, String phoneNumber, String event, String tags, String sort) throws ApiException {
        ApiResponse<GetSmsEventReport> resp = this.getSmsEventsWithHttpInfo(limit, startDate, endDate, offset, days, phoneNumber, event, tags, sort);
        return resp.getData();
    }

    public ApiResponse<GetSmsEventReport> getSmsEventsWithHttpInfo(Long limit, String startDate, String endDate, Long offset, Long days, String phoneNumber, String event, String tags, String sort) throws ApiException {
        Call call = this.getSmsEventsValidateBeforeCall(limit, startDate, endDate, offset, days, phoneNumber, event, tags, sort, null, null);
        Type localVarReturnType = new TypeToken<GetSmsEventReport>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSmsEventsAsync(Long limit, String startDate, String endDate, Long offset, Long days, String phoneNumber, String event, String tags, String sort, final ApiCallback<GetSmsEventReport> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSmsEventsValidateBeforeCall(limit, startDate, endDate, offset, days, phoneNumber, event, tags, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSmsEventReport>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransacAggregatedSmsReportCall(String startDate, String endDate, Long days, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/transactionalSMS/statistics/aggregatedReport";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (days != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransacAggregatedSmsReportValidateBeforeCall(String startDate, String endDate, Long days, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTransacAggregatedSmsReportCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        return call;
    }

    public GetTransacAggregatedSmsReport getTransacAggregatedSmsReport(String startDate, String endDate, Long days, String tag) throws ApiException {
        ApiResponse<GetTransacAggregatedSmsReport> resp = this.getTransacAggregatedSmsReportWithHttpInfo(startDate, endDate, days, tag);
        return resp.getData();
    }

    public ApiResponse<GetTransacAggregatedSmsReport> getTransacAggregatedSmsReportWithHttpInfo(String startDate, String endDate, Long days, String tag) throws ApiException {
        Call call = this.getTransacAggregatedSmsReportValidateBeforeCall(startDate, endDate, days, tag, null, null);
        Type localVarReturnType = new TypeToken<GetTransacAggregatedSmsReport>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransacAggregatedSmsReportAsync(String startDate, String endDate, Long days, String tag, final ApiCallback<GetTransacAggregatedSmsReport> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransacAggregatedSmsReportValidateBeforeCall(startDate, endDate, days, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacAggregatedSmsReport>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransacSmsReportCall(String startDate, String endDate, Long days, String tag, String sort, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/transactionalSMS/statistics/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (startDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("startDate", startDate));
        }
        if (endDate != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("endDate", endDate));
        }
        if (days != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("days", days));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransacSmsReportValidateBeforeCall(String startDate, String endDate, Long days, String tag, String sort, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getTransacSmsReportCall(startDate, endDate, days, tag, sort, progressListener, progressRequestListener);
        return call;
    }

    public GetTransacSmsReport getTransacSmsReport(String startDate, String endDate, Long days, String tag, String sort) throws ApiException {
        ApiResponse<GetTransacSmsReport> resp = this.getTransacSmsReportWithHttpInfo(startDate, endDate, days, tag, sort);
        return resp.getData();
    }

    public ApiResponse<GetTransacSmsReport> getTransacSmsReportWithHttpInfo(String startDate, String endDate, Long days, String tag, String sort) throws ApiException {
        Call call = this.getTransacSmsReportValidateBeforeCall(startDate, endDate, days, tag, sort, null, null);
        Type localVarReturnType = new TypeToken<GetTransacSmsReport>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTransacSmsReportAsync(String startDate, String endDate, Long days, String tag, String sort, final ApiCallback<GetTransacSmsReport> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransacSmsReportValidateBeforeCall(startDate, endDate, days, tag, sort, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetTransacSmsReport>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call sendTransacSmsCall(SendTransacSms sendTransacSms, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SendTransacSms localVarPostBody = sendTransacSms;
        String localVarPath = "/transactionalSMS/sms";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api-key", "partner-key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call sendTransacSmsValidateBeforeCall(SendTransacSms sendTransacSms, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (sendTransacSms == null) {
            throw new ApiException("Missing the required parameter 'sendTransacSms' when calling sendTransacSms(Async)");
        }
        Call call = this.sendTransacSmsCall(sendTransacSms, progressListener, progressRequestListener);
        return call;
    }

    public SendSms sendTransacSms(SendTransacSms sendTransacSms) throws ApiException {
        ApiResponse<SendSms> resp = this.sendTransacSmsWithHttpInfo(sendTransacSms);
        return resp.getData();
    }

    public ApiResponse<SendSms> sendTransacSmsWithHttpInfo(SendTransacSms sendTransacSms) throws ApiException {
        Call call = this.sendTransacSmsValidateBeforeCall(sendTransacSms, null, null);
        Type localVarReturnType = new TypeToken<SendSms>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call sendTransacSmsAsync(SendTransacSms sendTransacSms, final ApiCallback<SendSms> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.sendTransacSmsValidateBeforeCall(sendTransacSms, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SendSms>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

