/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * UpdateChildAccountStatus
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class UpdateChildAccountStatus {
  @SerializedName("transactionalEmail")
  private Boolean transactionalEmail = null;

  @SerializedName("transactionalSms")
  private Boolean transactionalSms = null;

  @SerializedName("marketingAutomation")
  private Boolean marketingAutomation = null;

  @SerializedName("smsCampaign")
  private Boolean smsCampaign = null;

  public UpdateChildAccountStatus transactionalEmail(Boolean transactionalEmail) {
    this.transactionalEmail = transactionalEmail;
    return this;
  }

   /**
   * Status of Transactional Email Platform activation for your account (true&#x3D;enabled, false&#x3D;disabled)
   * @return transactionalEmail
  **/
  @ApiModelProperty(example = "false", value = "Status of Transactional Email Platform activation for your account (true=enabled, false=disabled)")
  public Boolean isTransactionalEmail() {
    return transactionalEmail;
  }

  public void setTransactionalEmail(Boolean transactionalEmail) {
    this.transactionalEmail = transactionalEmail;
  }

  public UpdateChildAccountStatus transactionalSms(Boolean transactionalSms) {
    this.transactionalSms = transactionalSms;
    return this;
  }

   /**
   * Status of Transactional SMS Platform activation for your account (true&#x3D;enabled, false&#x3D;disabled)
   * @return transactionalSms
  **/
  @ApiModelProperty(example = "false", value = "Status of Transactional SMS Platform activation for your account (true=enabled, false=disabled)")
  public Boolean isTransactionalSms() {
    return transactionalSms;
  }

  public void setTransactionalSms(Boolean transactionalSms) {
    this.transactionalSms = transactionalSms;
  }

  public UpdateChildAccountStatus marketingAutomation(Boolean marketingAutomation) {
    this.marketingAutomation = marketingAutomation;
    return this;
  }

   /**
   * Status of Marketing Automation Platform activation for your account (true&#x3D;enabled, false&#x3D;disabled)
   * @return marketingAutomation
  **/
  @ApiModelProperty(example = "true", value = "Status of Marketing Automation Platform activation for your account (true=enabled, false=disabled)")
  public Boolean isMarketingAutomation() {
    return marketingAutomation;
  }

  public void setMarketingAutomation(Boolean marketingAutomation) {
    this.marketingAutomation = marketingAutomation;
  }

  public UpdateChildAccountStatus smsCampaign(Boolean smsCampaign) {
    this.smsCampaign = smsCampaign;
    return this;
  }

   /**
   * Status of SMS Campaign Platform activation for your account (true&#x3D;enabled, false&#x3D;disabled)
   * @return smsCampaign
  **/
  @ApiModelProperty(example = "true", value = "Status of SMS Campaign Platform activation for your account (true=enabled, false=disabled)")
  public Boolean isSmsCampaign() {
    return smsCampaign;
  }

  public void setSmsCampaign(Boolean smsCampaign) {
    this.smsCampaign = smsCampaign;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateChildAccountStatus updateChildAccountStatus = (UpdateChildAccountStatus) o;
    return Objects.equals(this.transactionalEmail, updateChildAccountStatus.transactionalEmail) &&
        Objects.equals(this.transactionalSms, updateChildAccountStatus.transactionalSms) &&
        Objects.equals(this.marketingAutomation, updateChildAccountStatus.marketingAutomation) &&
        Objects.equals(this.smsCampaign, updateChildAccountStatus.smsCampaign);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionalEmail, transactionalSms, marketingAutomation, smsCampaign);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateChildAccountStatus {\n");
    
    sb.append("    transactionalEmail: ").append(toIndentedString(transactionalEmail)).append("\n");
    sb.append("    transactionalSms: ").append(toIndentedString(transactionalSms)).append("\n");
    sb.append("    marketingAutomation: ").append(toIndentedString(marketingAutomation)).append("\n");
    sb.append("    smsCampaign: ").append(toIndentedString(smsCampaign)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

