/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * SendTransacSms
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class SendTransacSms {
  @SerializedName("sender")
  private String sender = null;

  @SerializedName("recipient")
  private String recipient = null;

  @SerializedName("content")
  private String content = null;

  /**
   * Type of the SMS. Marketing SMS messages are those sent typically with marketing content. Transactional SMS messages are sent to individuals and are triggered in response to some action, such as a sign-up, purchase, etc.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    TRANSACTIONAL("transactional"),
    
    MARKETING("marketing");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = TypeEnum.TRANSACTIONAL;

  @SerializedName("tag")
  private String tag = null;

  @SerializedName("webUrl")
  private String webUrl = null;

  @SerializedName("unicodeEnabled")
  private Boolean unicodeEnabled = false;

  public SendTransacSms sender(String sender) {
    this.sender = sender;
    return this;
  }

   /**
   * Name of the sender. **The number of characters is limited to 11 for alphanumeric characters and 15 for numeric characters**
   * @return sender
  **/
  @ApiModelProperty(example = "MyShop", required = true, value = "Name of the sender. **The number of characters is limited to 11 for alphanumeric characters and 15 for numeric characters**")
  public String getSender() {
    return sender;
  }

  public void setSender(String sender) {
    this.sender = sender;
  }

  public SendTransacSms recipient(String recipient) {
    this.recipient = recipient;
    return this;
  }

   /**
   * Mobile number to send SMS with the country code
   * @return recipient
  **/
  @ApiModelProperty(example = "33689965433", required = true, value = "Mobile number to send SMS with the country code")
  public String getRecipient() {
    return recipient;
  }

  public void setRecipient(String recipient) {
    this.recipient = recipient;
  }

  public SendTransacSms content(String content) {
    this.content = content;
    return this;
  }

   /**
   * Content of the message. If more than 160 characters long, will be sent as multiple text messages
   * @return content
  **/
  @ApiModelProperty(example = "Enter this code:CCJJG8 to validate your account", required = true, value = "Content of the message. If more than 160 characters long, will be sent as multiple text messages")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public SendTransacSms type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Type of the SMS. Marketing SMS messages are those sent typically with marketing content. Transactional SMS messages are sent to individuals and are triggered in response to some action, such as a sign-up, purchase, etc.
   * @return type
  **/
  @ApiModelProperty(example = "marketing", value = "Type of the SMS. Marketing SMS messages are those sent typically with marketing content. Transactional SMS messages are sent to individuals and are triggered in response to some action, such as a sign-up, purchase, etc.")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public SendTransacSms tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Tag of the message
   * @return tag
  **/
  @ApiModelProperty(example = "accountValidation", value = "Tag of the message")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }

  public SendTransacSms webUrl(String webUrl) {
    this.webUrl = webUrl;
    return this;
  }

   /**
   * Webhook to call for each event triggered by the message (delivered etc.)
   * @return webUrl
  **/
  @ApiModelProperty(example = "http://requestb.in/173lyyx1", value = "Webhook to call for each event triggered by the message (delivered etc.)")
  public String getWebUrl() {
    return webUrl;
  }

  public void setWebUrl(String webUrl) {
    this.webUrl = webUrl;
  }

  public SendTransacSms unicodeEnabled(Boolean unicodeEnabled) {
    this.unicodeEnabled = unicodeEnabled;
    return this;
  }

   /**
   * Format of the message. It indicates whether the content should be treated as unicode or not.
   * @return unicodeEnabled
  **/
  @ApiModelProperty(example = "true", value = "Format of the message. It indicates whether the content should be treated as unicode or not.")
  public Boolean isUnicodeEnabled() {
    return unicodeEnabled;
  }

  public void setUnicodeEnabled(Boolean unicodeEnabled) {
    this.unicodeEnabled = unicodeEnabled;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendTransacSms sendTransacSms = (SendTransacSms) o;
    return Objects.equals(this.sender, sendTransacSms.sender) &&
        Objects.equals(this.recipient, sendTransacSms.recipient) &&
        Objects.equals(this.content, sendTransacSms.content) &&
        Objects.equals(this.type, sendTransacSms.type) &&
        Objects.equals(this.tag, sendTransacSms.tag) &&
        Objects.equals(this.webUrl, sendTransacSms.webUrl) &&
        Objects.equals(this.unicodeEnabled, sendTransacSms.unicodeEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sender, recipient, content, type, tag, webUrl, unicodeEnabled);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendTransacSms {\n");
    
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    webUrl: ").append(toIndentedString(webUrl)).append("\n");
    sb.append("    unicodeEnabled: ").append(toIndentedString(unicodeEnabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

