/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sibModel.SendSmtpEmailBcc;
import sibModel.SendSmtpEmailCc;
import sibModel.SendSmtpEmailReplyTo1;
import sibModel.SendSmtpEmailTo1;

/**
 * SendSmtpEmailMessageVersions
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class SendSmtpEmailMessageVersions {
  @SerializedName("to")
  private List<SendSmtpEmailTo1> to = new ArrayList<SendSmtpEmailTo1>();

  @SerializedName("params")
  private Map<String, Object> params = null;

  @SerializedName("bcc")
  private List<SendSmtpEmailBcc> bcc = null;

  @SerializedName("cc")
  private List<SendSmtpEmailCc> cc = null;

  @SerializedName("replyTo")
  private SendSmtpEmailReplyTo1 replyTo = null;

  @SerializedName("subject")
  private String subject = null;

  public SendSmtpEmailMessageVersions to(List<SendSmtpEmailTo1> to) {
    this.to = to;
    return this;
  }

  public SendSmtpEmailMessageVersions addToItem(SendSmtpEmailTo1 toItem) {
    this.to.add(toItem);
    return this;
  }

   /**
   * List of email addresses and names (_optional_) of the recipients. For example, [{&quot;name&quot;:&quot;Jimmy&quot;, &quot;email&quot;:&quot;jimmy98@example.com&quot;}, {&quot;name&quot;:&quot;Joe&quot;, &quot;email&quot;:&quot;joe@example.com&quot;}]
   * @return to
  **/
  @ApiModelProperty(required = true, value = "List of email addresses and names (_optional_) of the recipients. For example, [{\"name\":\"Jimmy\", \"email\":\"jimmy98@example.com\"}, {\"name\":\"Joe\", \"email\":\"joe@example.com\"}]")
  public List<SendSmtpEmailTo1> getTo() {
    return to;
  }

  public void setTo(List<SendSmtpEmailTo1> to) {
    this.to = to;
  }

  public SendSmtpEmailMessageVersions params(Map<String, Object> params) {
    this.params = params;
    return this;
  }

  public SendSmtpEmailMessageVersions putParamsItem(String key, Object paramsItem) {
    if (this.params == null) {
      this.params = new HashMap<String, Object>();
    }
    this.params.put(key, paramsItem);
    return this;
  }

   /**
   * Pass the set of attributes to customize the template. For example, {&quot;FNAME&quot;:&quot;Joe&quot;, &quot;LNAME&quot;:&quot;Doe&quot;}. It&#39;s considered only if template is in New Template Language format.
   * @return params
  **/
  @ApiModelProperty(example = "{\"FNAME\":\"Joe\",\"LNAME\":\"Doe\"}", value = "Pass the set of attributes to customize the template. For example, {\"FNAME\":\"Joe\", \"LNAME\":\"Doe\"}. It's considered only if template is in New Template Language format.")
  public Map<String, Object> getParams() {
    return params;
  }

  public void setParams(Map<String, Object> params) {
    this.params = params;
  }

  public SendSmtpEmailMessageVersions bcc(List<SendSmtpEmailBcc> bcc) {
    this.bcc = bcc;
    return this;
  }

  public SendSmtpEmailMessageVersions addBccItem(SendSmtpEmailBcc bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<SendSmtpEmailBcc>();
    }
    this.bcc.add(bccItem);
    return this;
  }

   /**
   * List of email addresses and names (optional) of the recipients in bcc
   * @return bcc
  **/
  @ApiModelProperty(value = "List of email addresses and names (optional) of the recipients in bcc")
  public List<SendSmtpEmailBcc> getBcc() {
    return bcc;
  }

  public void setBcc(List<SendSmtpEmailBcc> bcc) {
    this.bcc = bcc;
  }

  public SendSmtpEmailMessageVersions cc(List<SendSmtpEmailCc> cc) {
    this.cc = cc;
    return this;
  }

  public SendSmtpEmailMessageVersions addCcItem(SendSmtpEmailCc ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<SendSmtpEmailCc>();
    }
    this.cc.add(ccItem);
    return this;
  }

   /**
   * List of email addresses and names (optional) of the recipients in cc
   * @return cc
  **/
  @ApiModelProperty(value = "List of email addresses and names (optional) of the recipients in cc")
  public List<SendSmtpEmailCc> getCc() {
    return cc;
  }

  public void setCc(List<SendSmtpEmailCc> cc) {
    this.cc = cc;
  }

  public SendSmtpEmailMessageVersions replyTo(SendSmtpEmailReplyTo1 replyTo) {
    this.replyTo = replyTo;
    return this;
  }

   /**
   * Get replyTo
   * @return replyTo
  **/
  @ApiModelProperty(value = "")
  public SendSmtpEmailReplyTo1 getReplyTo() {
    return replyTo;
  }

  public void setReplyTo(SendSmtpEmailReplyTo1 replyTo) {
    this.replyTo = replyTo;
  }

  public SendSmtpEmailMessageVersions subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Custom subject specific to message version 
   * @return subject
  **/
  @ApiModelProperty(example = "Login Email confirmation", value = "Custom subject specific to message version ")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendSmtpEmailMessageVersions sendSmtpEmailMessageVersions = (SendSmtpEmailMessageVersions) o;
    return Objects.equals(this.to, sendSmtpEmailMessageVersions.to) &&
        Objects.equals(this.params, sendSmtpEmailMessageVersions.params) &&
        Objects.equals(this.bcc, sendSmtpEmailMessageVersions.bcc) &&
        Objects.equals(this.cc, sendSmtpEmailMessageVersions.cc) &&
        Objects.equals(this.replyTo, sendSmtpEmailMessageVersions.replyTo) &&
        Objects.equals(this.subject, sendSmtpEmailMessageVersions.subject);
  }

  @Override
  public int hashCode() {
    return Objects.hash(to, params, bcc, cc, replyTo, subject);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendSmtpEmailMessageVersions {\n");
    
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

