/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import sibModel.MasterDetailsResponseBillingInfo;
import sibModel.MasterDetailsResponsePlanInfo;

/**
 * MasterDetailsResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class MasterDetailsResponse {
  @SerializedName("email")
  private String email = null;

  @SerializedName("companyName")
  private String companyName = null;

  @SerializedName("id")
  private Long id = null;

  @SerializedName("currencyCode")
  private String currencyCode = null;

  @SerializedName("timezone")
  private String timezone = null;

  @SerializedName("billingInfo")
  private MasterDetailsResponseBillingInfo billingInfo = null;

  @SerializedName("planInfo")
  private MasterDetailsResponsePlanInfo planInfo = null;

  public MasterDetailsResponse email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Email id of master account
   * @return email
  **/
  @ApiModelProperty(value = "Email id of master account")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public MasterDetailsResponse companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * Company name of master account organization
   * @return companyName
  **/
  @ApiModelProperty(value = "Company name of master account organization")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public MasterDetailsResponse id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * Unique identifier of the master account organization
   * @return id
  **/
  @ApiModelProperty(value = "Unique identifier of the master account organization")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public MasterDetailsResponse currencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
    return this;
  }

   /**
   * Currency code of the master account organization
   * @return currencyCode
  **/
  @ApiModelProperty(value = "Currency code of the master account organization")
  public String getCurrencyCode() {
    return currencyCode;
  }

  public void setCurrencyCode(String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public MasterDetailsResponse timezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone of the master account organization
   * @return timezone
  **/
  @ApiModelProperty(value = "Timezone of the master account organization")
  public String getTimezone() {
    return timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }

  public MasterDetailsResponse billingInfo(MasterDetailsResponseBillingInfo billingInfo) {
    this.billingInfo = billingInfo;
    return this;
  }

   /**
   * Get billingInfo
   * @return billingInfo
  **/
  @ApiModelProperty(value = "")
  public MasterDetailsResponseBillingInfo getBillingInfo() {
    return billingInfo;
  }

  public void setBillingInfo(MasterDetailsResponseBillingInfo billingInfo) {
    this.billingInfo = billingInfo;
  }

  public MasterDetailsResponse planInfo(MasterDetailsResponsePlanInfo planInfo) {
    this.planInfo = planInfo;
    return this;
  }

   /**
   * Get planInfo
   * @return planInfo
  **/
  @ApiModelProperty(value = "")
  public MasterDetailsResponsePlanInfo getPlanInfo() {
    return planInfo;
  }

  public void setPlanInfo(MasterDetailsResponsePlanInfo planInfo) {
    this.planInfo = planInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MasterDetailsResponse masterDetailsResponse = (MasterDetailsResponse) o;
    return Objects.equals(this.email, masterDetailsResponse.email) &&
        Objects.equals(this.companyName, masterDetailsResponse.companyName) &&
        Objects.equals(this.id, masterDetailsResponse.id) &&
        Objects.equals(this.currencyCode, masterDetailsResponse.currencyCode) &&
        Objects.equals(this.timezone, masterDetailsResponse.timezone) &&
        Objects.equals(this.billingInfo, masterDetailsResponse.billingInfo) &&
        Objects.equals(this.planInfo, masterDetailsResponse.planInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, companyName, id, currencyCode, timezone, billingInfo, planInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MasterDetailsResponse {\n");
    
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    billingInfo: ").append(toIndentedString(billingInfo)).append("\n");
    sb.append("    planInfo: ").append(toIndentedString(planInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

