/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * GetTransacEmailsListTransactionalEmails
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class GetTransacEmailsListTransactionalEmails {
  @SerializedName("email")
  private String email = null;

  @SerializedName("subject")
  private String subject = null;

  @SerializedName("templateId")
  private Long templateId = null;

  @SerializedName("messageId")
  private String messageId = null;

  @SerializedName("uuid")
  private String uuid = null;

  @SerializedName("date")
  private String date = null;

  @SerializedName("from")
  private String from = null;

  @SerializedName("tags")
  private List<String> tags = null;

  public GetTransacEmailsListTransactionalEmails email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Email address to which transactional email has been sent
   * @return email
  **/
  @ApiModelProperty(example = "john.smith@example.com", required = true, value = "Email address to which transactional email has been sent")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public GetTransacEmailsListTransactionalEmails subject(String subject) {
    this.subject = subject;
    return this;
  }

   /**
   * Subject of the sent email
   * @return subject
  **/
  @ApiModelProperty(example = "Summer Camp", required = true, value = "Subject of the sent email")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public GetTransacEmailsListTransactionalEmails templateId(Long templateId) {
    this.templateId = templateId;
    return this;
  }

   /**
   * Id of the template
   * @return templateId
  **/
  @ApiModelProperty(example = "2", value = "Id of the template")
  public Long getTemplateId() {
    return templateId;
  }

  public void setTemplateId(Long templateId) {
    this.templateId = templateId;
  }

  public GetTransacEmailsListTransactionalEmails messageId(String messageId) {
    this.messageId = messageId;
    return this;
  }

   /**
   * Message Id of the sent email
   * @return messageId
  **/
  @ApiModelProperty(example = "<201798300811.5700093@relay.domain.com>", required = true, value = "Message Id of the sent email")
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public GetTransacEmailsListTransactionalEmails uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

   /**
   * Unique id of the email sent to a particular contact
   * @return uuid
  **/
  @ApiModelProperty(example = "5a78c-209ok98262910-s99a341", required = true, value = "Unique id of the email sent to a particular contact")
  public String getUuid() {
    return uuid;
  }

  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  public GetTransacEmailsListTransactionalEmails date(String date) {
    this.date = date;
    return this;
  }

   /**
   * Date on which transactional email was sent
   * @return date
  **/
  @ApiModelProperty(example = "2017-03-12T12:30:00Z", required = true, value = "Date on which transactional email was sent")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public GetTransacEmailsListTransactionalEmails from(String from) {
    this.from = from;
    return this;
  }

   /**
   * Email address of the sender from which the email was sent
   * @return from
  **/
  @ApiModelProperty(example = "diana.doe@example.com", value = "Email address of the sender from which the email was sent")
  public String getFrom() {
    return from;
  }

  public void setFrom(String from) {
    this.from = from;
  }

  public GetTransacEmailsListTransactionalEmails tags(List<String> tags) {
    this.tags = tags;
    return this;
  }

  public GetTransacEmailsListTransactionalEmails addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<String>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Tags used for your email
   * @return tags
  **/
  @ApiModelProperty(value = "Tags used for your email")
  public List<String> getTags() {
    return tags;
  }

  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetTransacEmailsListTransactionalEmails getTransacEmailsListTransactionalEmails = (GetTransacEmailsListTransactionalEmails) o;
    return Objects.equals(this.email, getTransacEmailsListTransactionalEmails.email) &&
        Objects.equals(this.subject, getTransacEmailsListTransactionalEmails.subject) &&
        Objects.equals(this.templateId, getTransacEmailsListTransactionalEmails.templateId) &&
        Objects.equals(this.messageId, getTransacEmailsListTransactionalEmails.messageId) &&
        Objects.equals(this.uuid, getTransacEmailsListTransactionalEmails.uuid) &&
        Objects.equals(this.date, getTransacEmailsListTransactionalEmails.date) &&
        Objects.equals(this.from, getTransacEmailsListTransactionalEmails.from) &&
        Objects.equals(this.tags, getTransacEmailsListTransactionalEmails.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, subject, templateId, messageId, uuid, date, from, tags);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTransacEmailsListTransactionalEmails {\n");
    
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

