/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * GetSmsEventReportEvents
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class GetSmsEventReportEvents {
  @SerializedName("phoneNumber")
  private String phoneNumber = null;

  @SerializedName("date")
  private String date = null;

  @SerializedName("messageId")
  private String messageId = null;

  /**
   * Event which occurred
   */
  @JsonAdapter(EventEnum.Adapter.class)
  public enum EventEnum {
    BOUNCES("bounces"),
    
    HARDBOUNCES("hardBounces"),
    
    SOFTBOUNCES("softBounces"),
    
    DELIVERED("delivered"),
    
    SENT("sent"),
    
    ACCEPTED("accepted"),
    
    UNSUBSCRIPTION("unsubscription"),
    
    REPLIES("replies"),
    
    BLOCKED("blocked");

    private String value;

    EventEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static EventEnum fromValue(String text) {
      for (EventEnum b : EventEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<EventEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final EventEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public EventEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return EventEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("event")
  private EventEnum event = null;

  @SerializedName("reason")
  private String reason = null;

  @SerializedName("reply")
  private String reply = null;

  @SerializedName("tag")
  private String tag = null;

  public GetSmsEventReportEvents phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

   /**
   * Phone number which has generated the event
   * @return phoneNumber
  **/
  @ApiModelProperty(example = "00189001094", value = "Phone number which has generated the event")
  public String getPhoneNumber() {
    return phoneNumber;
  }

  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }

  public GetSmsEventReportEvents date(String date) {
    this.date = date;
    return this;
  }

   /**
   * UTC date-time on which the event has been generated
   * @return date
  **/
  @ApiModelProperty(example = "2017-03-12T12:30:00Z", value = "UTC date-time on which the event has been generated")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public GetSmsEventReportEvents messageId(String messageId) {
    this.messageId = messageId;
    return this;
  }

   /**
   * Message ID which generated the event
   * @return messageId
  **/
  @ApiModelProperty(example = "1472640582425378", value = "Message ID which generated the event")
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public GetSmsEventReportEvents event(EventEnum event) {
    this.event = event;
    return this;
  }

   /**
   * Event which occurred
   * @return event
  **/
  @ApiModelProperty(example = "accepted", value = "Event which occurred")
  public EventEnum getEvent() {
    return event;
  }

  public void setEvent(EventEnum event) {
    this.event = event;
  }

  public GetSmsEventReportEvents reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * Reason of bounce (only available if the event is hardbounce or softbounce)
   * @return reason
  **/
  @ApiModelProperty(example = "Message is undeliverable due to an incorrect / invalid / blacklisted / permanently barred MSISDN for this operator", value = "Reason of bounce (only available if the event is hardbounce or softbounce)")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public GetSmsEventReportEvents reply(String reply) {
    this.reply = reply;
    return this;
  }

   /**
   * Get reply
   * @return reply
  **/
  @ApiModelProperty(value = "")
  public String getReply() {
    return reply;
  }

  public void setReply(String reply) {
    this.reply = reply;
  }

  public GetSmsEventReportEvents tag(String tag) {
    this.tag = tag;
    return this;
  }

   /**
   * Tag of the SMS which generated the event
   * @return tag
  **/
  @ApiModelProperty(example = "CabWaiting", value = "Tag of the SMS which generated the event")
  public String getTag() {
    return tag;
  }

  public void setTag(String tag) {
    this.tag = tag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetSmsEventReportEvents getSmsEventReportEvents = (GetSmsEventReportEvents) o;
    return Objects.equals(this.phoneNumber, getSmsEventReportEvents.phoneNumber) &&
        Objects.equals(this.date, getSmsEventReportEvents.date) &&
        Objects.equals(this.messageId, getSmsEventReportEvents.messageId) &&
        Objects.equals(this.event, getSmsEventReportEvents.event) &&
        Objects.equals(this.reason, getSmsEventReportEvents.reason) &&
        Objects.equals(this.reply, getSmsEventReportEvents.reply) &&
        Objects.equals(this.tag, getSmsEventReportEvents.tag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumber, date, messageId, event, reason, reply, tag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetSmsEventReportEvents {\n");
    
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    reply: ").append(toIndentedString(reply)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

