/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import sibModel.GetAttributesEnumeration;

/**
 * GetAttributesAttributes
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class GetAttributesAttributes {
  @SerializedName("name")
  private String name = null;

  /**
   * Category of the attribute
   */
  @JsonAdapter(CategoryEnum.Adapter.class)
  public enum CategoryEnum {
    NORMAL("normal"),
    
    TRANSACTIONAL("transactional"),
    
    CATEGORY("category"),
    
    CALCULATED("calculated"),
    
    GLOBAL("global");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CategoryEnum fromValue(String text) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<CategoryEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CategoryEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CategoryEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return CategoryEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("category")
  private CategoryEnum category = null;

  /**
   * Type of the attribute
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    TEXT("text"),
    
    DATE("date"),
    
    FLOAT("float"),
    
    ID("id"),
    
    BOOLEAN("boolean");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("enumeration")
  private List<GetAttributesEnumeration> enumeration = null;

  @SerializedName("calculatedValue")
  private String calculatedValue = null;

  public GetAttributesAttributes name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of the attribute
   * @return name
  **/
  @ApiModelProperty(example = "LASTNAME", required = true, value = "Name of the attribute")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public GetAttributesAttributes category(CategoryEnum category) {
    this.category = category;
    return this;
  }

   /**
   * Category of the attribute
   * @return category
  **/
  @ApiModelProperty(example = "category", required = true, value = "Category of the attribute")
  public CategoryEnum getCategory() {
    return category;
  }

  public void setCategory(CategoryEnum category) {
    this.category = category;
  }

  public GetAttributesAttributes type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Type of the attribute
   * @return type
  **/
  @ApiModelProperty(example = "text", value = "Type of the attribute")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public GetAttributesAttributes enumeration(List<GetAttributesEnumeration> enumeration) {
    this.enumeration = enumeration;
    return this;
  }

  public GetAttributesAttributes addEnumerationItem(GetAttributesEnumeration enumerationItem) {
    if (this.enumeration == null) {
      this.enumeration = new ArrayList<GetAttributesEnumeration>();
    }
    this.enumeration.add(enumerationItem);
    return this;
  }

   /**
   * Parameter only available for &quot;category&quot; type attributes.
   * @return enumeration
  **/
  @ApiModelProperty(value = "Parameter only available for \"category\" type attributes.")
  public List<GetAttributesEnumeration> getEnumeration() {
    return enumeration;
  }

  public void setEnumeration(List<GetAttributesEnumeration> enumeration) {
    this.enumeration = enumeration;
  }

  public GetAttributesAttributes calculatedValue(String calculatedValue) {
    this.calculatedValue = calculatedValue;
    return this;
  }

   /**
   * Calculated value formula
   * @return calculatedValue
  **/
  @ApiModelProperty(example = "COUNT[ORDER_ID,ORDER_DATE,==,NOW(-1)]", value = "Calculated value formula")
  public String getCalculatedValue() {
    return calculatedValue;
  }

  public void setCalculatedValue(String calculatedValue) {
    this.calculatedValue = calculatedValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAttributesAttributes getAttributesAttributes = (GetAttributesAttributes) o;
    return Objects.equals(this.name, getAttributesAttributes.name) &&
        Objects.equals(this.category, getAttributesAttributes.category) &&
        Objects.equals(this.type, getAttributesAttributes.type) &&
        Objects.equals(this.enumeration, getAttributesAttributes.enumeration) &&
        Objects.equals(this.calculatedValue, getAttributesAttributes.calculatedValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, category, type, enumeration, calculatedValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAttributesAttributes {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    enumeration: ").append(toIndentedString(enumeration)).append("\n");
    sb.append("    calculatedValue: ").append(toIndentedString(calculatedValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

