/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.threeten.bp.OffsetDateTime;

/**
 * File data that is uploaded
 */
@ApiModel(description = "File data that is uploaded")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class FileData {
  @SerializedName("url")
  private String url = null;

  @SerializedName("id")
  private String id = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("authorId")
  private String authorId = null;

  @SerializedName("author")
  private Object author = null;

  @SerializedName("contactId")
  private Long contactId = null;

  @SerializedName("dealIds")
  private List<String> dealIds = null;

  @SerializedName("size")
  private Long size = null;

  @SerializedName("createdAt")
  private OffsetDateTime createdAt = null;

  @SerializedName("updatedAt")
  private OffsetDateTime updatedAt = null;

  public FileData url(String url) {
    this.url = url;
    return this;
  }

   /**
   * Url of uploaded file
   * @return url
  **/
  @ApiModelProperty(example = "/api/v1/files/61a88a2eb7a574180261234", value = "Url of uploaded file")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public FileData id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Id of uploaded file
   * @return id
  **/
  @ApiModelProperty(example = "61a88a2eb7a574180261234", value = "Id of uploaded file")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FileData name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of uploaded file
   * @return name
  **/
  @ApiModelProperty(example = "example.png", value = "Name of uploaded file")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public FileData authorId(String authorId) {
    this.authorId = authorId;
    return this;
  }

   /**
   * Account id of user which created the file
   * @return authorId
  **/
  @ApiModelProperty(example = "61a5ce58y5d4795761045991", value = "Account id of user which created the file")
  public String getAuthorId() {
    return authorId;
  }

  public void setAuthorId(String authorId) {
    this.authorId = authorId;
  }

  public FileData author(Object author) {
    this.author = author;
    return this;
  }

   /**
   * Account details of user which created the file
   * @return author
  **/
  @ApiModelProperty(example = "{\"id\":\"61a5ce58y5d4795761045991\",\"email\":\"johndoe@example.com\",\"locale\":\"en_GB\",\"timezone\":\"Asia/Kolkata\",\"name\":{\"fullName\":\"John Doe\"}}", value = "Account details of user which created the file")
  public Object getAuthor() {
    return author;
  }

  public void setAuthor(Object author) {
    this.author = author;
  }

  public FileData contactId(Long contactId) {
    this.contactId = contactId;
    return this;
  }

   /**
   * Contact id of contact on which file is uploaded
   * @return contactId
  **/
  @ApiModelProperty(example = "1", value = "Contact id of contact on which file is uploaded")
  public Long getContactId() {
    return contactId;
  }

  public void setContactId(Long contactId) {
    this.contactId = contactId;
  }

  public FileData dealIds(List<String> dealIds) {
    this.dealIds = dealIds;
    return this;
  }

  public FileData addDealIdsItem(String dealIdsItem) {
    if (this.dealIds == null) {
      this.dealIds = new ArrayList<String>();
    }
    this.dealIds.add(dealIdsItem);
    return this;
  }

   /**
   * Deal ids linked to a file
   * @return dealIds
  **/
  @ApiModelProperty(example = "[\"61a5ce58c5d4795761045990\",\"61a5ce58c5d4795761045991\"]", value = "Deal ids linked to a file")
  public List<String> getDealIds() {
    return dealIds;
  }

  public void setDealIds(List<String> dealIds) {
    this.dealIds = dealIds;
  }

  public FileData size(Long size) {
    this.size = size;
    return this;
  }

   /**
   * Size of file uploaded
   * @return size
  **/
  @ApiModelProperty(example = "10", value = "Size of file uploaded")
  public Long getSize() {
    return size;
  }

  public void setSize(Long size) {
    this.size = size;
  }

  public FileData createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * File created date/time
   * @return createdAt
  **/
  @ApiModelProperty(example = "2017-05-01T17:05:03.000Z", value = "File created date/time")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public FileData updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * File updated date/time
   * @return updatedAt
  **/
  @ApiModelProperty(example = "2017-05-01T17:05:03.000Z", value = "File updated date/time")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileData fileData = (FileData) o;
    return Objects.equals(this.url, fileData.url) &&
        Objects.equals(this.id, fileData.id) &&
        Objects.equals(this.name, fileData.name) &&
        Objects.equals(this.authorId, fileData.authorId) &&
        Objects.equals(this.author, fileData.author) &&
        Objects.equals(this.contactId, fileData.contactId) &&
        Objects.equals(this.dealIds, fileData.dealIds) &&
        Objects.equals(this.size, fileData.size) &&
        Objects.equals(this.createdAt, fileData.createdAt) &&
        Objects.equals(this.updatedAt, fileData.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, id, name, authorId, author, contactId, dealIds, size, createdAt, updatedAt);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileData {\n");
    
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    authorId: ").append(toIndentedString(authorId)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    dealIds: ").append(toIndentedString(dealIds)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

