/*
 * SendinBlue API
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  | 
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package sibModel;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.threeten.bp.OffsetDateTime;

/**
 * Contact Details
 */
@ApiModel(description = "Contact Details")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-03-02T23:12:13.151+05:30")
public class Contact {
  @SerializedName("virtualNextTask")
  private Object virtualNextTask = null;

  @SerializedName("email")
  private String email = null;

  @SerializedName("assignToId")
  private String assignToId = null;

  @SerializedName("contactsId")
  private Integer contactsId = null;

  @SerializedName("crmLists")
  private Object crmLists = null;

  @SerializedName("attributes")
  private Object attributes = null;

  @SerializedName("createdAt")
  private OffsetDateTime createdAt = null;

  @SerializedName("updatedAt")
  private OffsetDateTime updatedAt = null;

  public Contact virtualNextTask(Object virtualNextTask) {
    this.virtualNextTask = virtualNextTask;
    return this;
  }

   /**
   * Next incomplete task of contact
   * @return virtualNextTask
  **/
  @ApiModelProperty(example = "{\"id\":\"618e030658282f0555259086\",\"date\":\"2021-11-12T06:30:00+00:00\",\"done\":false}", value = "Next incomplete task of contact")
  public Object getVirtualNextTask() {
    return virtualNextTask;
  }

  public void setVirtualNextTask(Object virtualNextTask) {
    this.virtualNextTask = virtualNextTask;
  }

  public Contact email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Contact email
   * @return email
  **/
  @ApiModelProperty(example = "contact@example.com", required = true, value = "Contact email")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public Contact assignToId(String assignToId) {
    this.assignToId = assignToId;
    return this;
  }

   /**
   * User id to whom contact is assigned
   * @return assignToId
  **/
  @ApiModelProperty(example = "5faab4b7f195bb3c4c31e62a", value = "User id to whom contact is assigned")
  public String getAssignToId() {
    return assignToId;
  }

  public void setAssignToId(String assignToId) {
    this.assignToId = assignToId;
  }

  public Contact contactsId(Integer contactsId) {
    this.contactsId = contactsId;
    return this;
  }

   /**
   * Contact id
   * @return contactsId
  **/
  @ApiModelProperty(example = "247", value = "Contact id")
  public Integer getContactsId() {
    return contactsId;
  }

  public void setContactsId(Integer contactsId) {
    this.contactsId = contactsId;
  }

  public Contact crmLists(Object crmLists) {
    this.crmLists = crmLists;
    return this;
  }

   /**
   * CRM lists in which contact is added
   * @return crmLists
  **/
  @ApiModelProperty(example = "[43,58]", required = true, value = "CRM lists in which contact is added")
  public Object getCrmLists() {
    return crmLists;
  }

  public void setCrmLists(Object crmLists) {
    this.crmLists = crmLists;
  }

  public Contact attributes(Object attributes) {
    this.attributes = attributes;
    return this;
  }

   /**
   * Contact attributes e.g firstname / lastname / SMS etc.
   * @return attributes
  **/
  @ApiModelProperty(example = "{\"SMS\":\"33058407250\",\"IDENTIFICATION\":\"1-3RHQ-259\",\"CIV\":\"MS\",\"LAST_NAME\":\"Brennon\",\"FIRST_NAME\":\"Meg\",\"DOB\":\"1986-05-02T00:00:00.000Z\",\"ADDRESS\":\"1 5th avenue\",\"ZIP_CODE\":\"44300\",\"CITY\":\"New-York\",\"ACTION_CODE\":\"17HH98CH\"}", value = "Contact attributes e.g firstname / lastname / SMS etc.")
  public Object getAttributes() {
    return attributes;
  }

  public void setAttributes(Object attributes) {
    this.attributes = attributes;
  }

  public Contact createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Contact created date/time
   * @return createdAt
  **/
  @ApiModelProperty(example = "2017-05-01T17:05:03.000Z", value = "Contact created date/time")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Contact updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

   /**
   * Contact updated date/time
   * @return updatedAt
  **/
  @ApiModelProperty(example = "2017-05-01T17:05:03.000Z", value = "Contact updated date/time")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Contact contact = (Contact) o;
    return Objects.equals(this.virtualNextTask, contact.virtualNextTask) &&
        Objects.equals(this.email, contact.email) &&
        Objects.equals(this.assignToId, contact.assignToId) &&
        Objects.equals(this.contactsId, contact.contactsId) &&
        Objects.equals(this.crmLists, contact.crmLists) &&
        Objects.equals(this.attributes, contact.attributes) &&
        Objects.equals(this.createdAt, contact.createdAt) &&
        Objects.equals(this.updatedAt, contact.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(virtualNextTask, email, assignToId, contactsId, crmLists, attributes, createdAt, updatedAt);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Contact {\n");
    
    sb.append("    virtualNextTask: ").append(toIndentedString(virtualNextTask)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    assignToId: ").append(toIndentedString(assignToId)).append("\n");
    sb.append("    contactsId: ").append(toIndentedString(contactsId)).append("\n");
    sb.append("    crmLists: ").append(toIndentedString(crmLists)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

